/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.demos.frontendkarafdemo;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.priv.bang.demos.frontendkarafdemo.Counter;
import no.priv.bang.demos.frontendkarafdemo.Error;
import no.priv.bang.osgi.service.adapters.logservice.LoggerAdapter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.osgi.service.log.LogService;

@Component(service={Servlet.class})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=frontend-demo)")
@HttpWhiteboardServletPattern(value={"/api/increment"})
public class IncrementerServlet
extends HttpServlet {
    private static final long serialVersionUID = 103245292629129445L;
    static final ObjectMapper mapper = new ObjectMapper();
    final LoggerAdapter logger = new LoggerAdapter(((Object)((Object)this)).getClass());

    @Reference
    public void setLogService(LogService logservice) {
        this.logger.setLogService(logservice);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        try (ServletInputStream postBody = request.getInputStream();){
            Counter incrementedCounter = this.increment((Counter)mapper.readValue((InputStream)postBody, Counter.class));
            response.setStatus(200);
            try (PrintWriter responseBody = response.getWriter();){
                mapper.writeValue((Writer)responseBody, (Object)incrementedCounter);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to increment the counter value", (Object)e);
            response.setStatus(500);
            try (PrintWriter responseBody = response.getWriter();){
                mapper.writeValue((Writer)responseBody, (Object)Error.with().status(500).message(e.getMessage()).build());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Counter increment(Counter counter) {
        int delta = counter.delta();
        return Counter.with().value(counter.value() + delta).delta(delta).build();
    }
}

