/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.handlereg.backend;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Month;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import no.priv.bang.handlereg.services.Butikk;
import no.priv.bang.handlereg.services.ButikkCount;
import no.priv.bang.handlereg.services.ButikkDate;
import no.priv.bang.handlereg.services.ButikkSum;
import no.priv.bang.handlereg.services.Favoritt;
import no.priv.bang.handlereg.services.Favorittpar;
import no.priv.bang.handlereg.services.HandleregException;
import no.priv.bang.handlereg.services.HandleregService;
import no.priv.bang.handlereg.services.NyFavoritt;
import no.priv.bang.handlereg.services.NyHandling;
import no.priv.bang.handlereg.services.Oversikt;
import no.priv.bang.handlereg.services.SumYear;
import no.priv.bang.handlereg.services.SumYearMonth;
import no.priv.bang.handlereg.services.Transaction;
import no.priv.bang.osgiservice.users.Role;
import no.priv.bang.osgiservice.users.UserManagementService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Component(service={HandleregService.class}, immediate=true)
public class HandleregServiceProvider
implements HandleregService {
    private static final String STORE_NAME = "store_name";
    private static final String REKKEFOLGE = "rekkefolge";
    private static final String GRUPPE = "gruppe";
    private static final String TRANSACTION_ID = "transaction_id";
    private static final String ACCOUNT_ID = "account_id";
    private static final String STORE_ID = "store_id";
    private static final String AGGREGATE_AMOUNT = "aggregate_amount";
    private Logger logger;
    private DataSource datasource;
    private UserManagementService useradmin;

    @Reference
    public void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(HandleregServiceProvider.class);
    }

    @Reference(target="(osgi.jndi.service.name=jdbc/handlereg)")
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Reference
    public void setUseradmin(UserManagementService useradmin) {
        this.useradmin = useradmin;
    }

    @Activate
    public void activate() {
        this.addRolesIfNotpresent();
    }

    /*
     * Exception decompiling
     */
    public Oversikt finnOversikt(String brukernavn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Transaction> findTransactions(int userId, int pageNumber, int pageSize) {
        ArrayList<Transaction> handlinger = new ArrayList<Transaction>();
        String sql = "select t.transaction_id, t.transaction_time, s.store_name, s.store_id, t.transaction_amount from transactions t join stores s on s.store_id=t.store_id where t.account_id=? order by t.transaction_time desc offset ? rows fetch next ? rows only";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, userId);
            statement.setInt(2, pageNumber * pageSize);
            statement.setInt(3, pageSize);
            try (ResultSet results = statement.executeQuery();){
                while (results.next()) {
                    Transaction transaction = Transaction.with().transactionId(results.getInt(TRANSACTION_ID)).handletidspunkt(new Date(results.getTimestamp("transaction_time").getTime())).butikk(results.getString(STORE_NAME)).storeId(results.getInt(STORE_ID)).belop(results.getDouble("transaction_amount")).build();
                    handlinger.add(transaction);
                }
            }
        }
        catch (SQLException e) {
            throw new HandleregException(String.format("Failed to retrieve a list of transactions for account number %d", userId), (Throwable)e);
        }
        return handlinger;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Oversikt registrerHandling(NyHandling handling) {
        Date transactionTime = handling.handletidspunkt() == null ? new Date() : handling.handletidspunkt();
        String sql = "insert into transactions (account_id, store_id, transaction_amount, transaction_time) values ((select account_id from accounts where username=?), ?, ?, ?)";
        try (Connection connection = this.datasource.getConnection();){
            Oversikt oversikt;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setString(1, handling.username());
                    statement.setInt(2, handling.storeId());
                    statement.setDouble(3, handling.belop());
                    statement.setTimestamp(4, Timestamp.from(transactionTime.toInstant()));
                    statement.executeUpdate();
                    oversikt = this.finnOversikt(handling.username());
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return oversikt;
        }
        catch (SQLException e) {
            throw new HandleregException(String.format("Failed to register purchase for user %s", handling.username()), (Throwable)e);
        }
    }

    public List<Butikk> finnButikker() {
        ArrayList<Butikk> butikker = new ArrayList<Butikk>();
        String sql = "select store_id, store_name, gruppe, rekkefolge from stores where not deaktivert order by gruppe, rekkefolge";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                Butikk butikk = Butikk.with().storeId(results.getInt(STORE_ID)).butikknavn(results.getString(STORE_NAME)).gruppe(results.getInt(GRUPPE)).rekkefolge(results.getInt(REKKEFOLGE)).build();
                butikker.add(butikk);
            }
        }
        catch (SQLException e) {
            throw new HandleregException("Failed to retrieve a list of stores", (Throwable)e);
        }
        return butikker;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Butikk> endreButikk(Butikk butikkSomSkalEndres) {
        int butikkId = butikkSomSkalEndres.storeId();
        String butikknavn = Optional.ofNullable(butikkSomSkalEndres.butikknavn()).map(String::trim).orElse(null);
        int gruppe = butikkSomSkalEndres.gruppe();
        int rekkefolge = butikkSomSkalEndres.rekkefolge();
        String sql = "update stores set store_name=?, gruppe=?, rekkefolge=? where store_id=?";
        try (Connection connection = this.datasource.getConnection();){
            List<Butikk> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setString(1, butikknavn);
                    statement.setInt(2, gruppe);
                    statement.setInt(3, rekkefolge);
                    statement.setInt(4, butikkId);
                    statement.executeUpdate();
                    list = this.finnButikker();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new HandleregException(String.format("Failed to insert store \"%s\" in group %d, sort order %s", butikkSomSkalEndres.butikknavn(), gruppe, rekkefolge), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Butikk> leggTilButikk(Butikk nybutikk) {
        int gruppe = nybutikk.gruppe() < 1 ? 2 : nybutikk.gruppe();
        int rekkefolge = nybutikk.rekkefolge() < 1 ? this.finnNesteLedigeRekkefolgeForGruppe(gruppe) : nybutikk.rekkefolge();
        String sql = "insert into stores (store_name, gruppe, rekkefolge) values (?, ?, ?)";
        try (Connection connection = this.datasource.getConnection();){
            List<Butikk> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setString(1, nybutikk.butikknavn().trim());
                    statement.setInt(2, gruppe);
                    statement.setInt(3, rekkefolge);
                    statement.executeUpdate();
                    list = this.finnButikker();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new HandleregException(String.format("Failed to modify store \"%s\" in group %d, sort order %s", nybutikk.butikknavn(), gruppe, rekkefolge), (Throwable)e);
        }
    }

    public List<ButikkSum> sumOverButikk() {
        ArrayList<ButikkSum> sumOverButikk = new ArrayList<ButikkSum>();
        String sql = "select s.store_id, s.store_name, s.gruppe, s.rekkefolge, sum(t.transaction_amount) as totalbelop from transactions t join stores s on s.store_id=t.store_id group by s.store_id, s.store_name, s.gruppe, s.rekkefolge order by totalbelop desc";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                Butikk butikk = Butikk.with().storeId(results.getInt(STORE_ID)).butikknavn(results.getString(STORE_NAME)).gruppe(results.getInt(GRUPPE)).rekkefolge(results.getInt(REKKEFOLGE)).build();
                ButikkSum butikkSum = ButikkSum.with().butikk(butikk).sum(results.getDouble("totalbelop")).build();
                sumOverButikk.add(butikkSum);
            }
        }
        catch (SQLException e) {
            this.logWarning("Got error when retrieving sum over stores", e);
        }
        return sumOverButikk;
    }

    public List<ButikkCount> antallHandlingerIButikk() {
        ArrayList<ButikkCount> antallHandlerIButikk = new ArrayList<ButikkCount>();
        String sql = "select s.store_id, s.store_name, s.gruppe, s.rekkefolge, count(t.transaction_amount) as antallbesok from transactions t join stores s on s.store_id=t.store_id group by s.store_id, s.store_name, s.gruppe, s.rekkefolge order by antallbesok desc";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                Butikk butikk = Butikk.with().storeId(results.getInt(STORE_ID)).butikknavn(results.getString(STORE_NAME)).gruppe(results.getInt(GRUPPE)).rekkefolge(results.getInt(REKKEFOLGE)).build();
                ButikkCount butikkSum = ButikkCount.with().butikk(butikk).count(results.getLong("antallbesok")).build();
                antallHandlerIButikk.add(butikkSum);
            }
        }
        catch (SQLException e) {
            this.logWarning("Got error when retrieving count of the number of times store have been visited", e);
        }
        return antallHandlerIButikk;
    }

    public List<ButikkDate> sisteHandelIButikk() {
        ArrayList<ButikkDate> sisteHandelIButikk = new ArrayList<ButikkDate>();
        String sql = "select s.store_id, s.store_name, s.gruppe, s.rekkefolge, MAX(t.transaction_time) as handletid from transactions t join stores s on s.store_id=t.store_id group by s.store_id, s.store_name, s.gruppe, s.rekkefolge order by handletid desc";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                Butikk butikk = Butikk.with().storeId(results.getInt(STORE_ID)).butikknavn(results.getString(STORE_NAME)).gruppe(results.getInt(GRUPPE)).rekkefolge(results.getInt(REKKEFOLGE)).build();
                ButikkDate butikkSum = ButikkDate.with().butikk(butikk).date(new Date(results.getTimestamp("handletid").getTime())).build();
                sisteHandelIButikk.add(butikkSum);
            }
        }
        catch (SQLException e) {
            this.logWarning("Got error when retrieving last visit times for stores", e);
        }
        return sisteHandelIButikk;
    }

    public List<SumYear> totaltHandlebelopPrAar() {
        ArrayList<SumYear> totaltHandlebelopPrAar = new ArrayList<SumYear>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select aggregate_amount, aggregate_year from sum_over_year_view order by aggregate_year desc");
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                SumYear sumMonth = SumYear.with().sum(results.getDouble(AGGREGATE_AMOUNT)).year(Year.of(results.getInt("aggregate_year"))).build();
                totaltHandlebelopPrAar.add(sumMonth);
            }
        }
        catch (SQLException e) {
            this.logWarning("Got error when retrieving total amount used per year", e);
        }
        return totaltHandlebelopPrAar;
    }

    public List<SumYearMonth> totaltHandlebelopPrAarOgMaaned() {
        ArrayList<SumYearMonth> totaltHandlebelopPrAarOgMaaned = new ArrayList<SumYearMonth>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select aggregate_amount, aggregate_year, aggregate_month from sum_over_month_view order by aggregate_year desc, aggregate_month desc");
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                SumYearMonth sumMonth = SumYearMonth.with().sum(results.getDouble(AGGREGATE_AMOUNT)).year(Year.of(results.getInt("aggregate_year"))).month(Month.of(results.getInt("aggregate_month"))).build();
                totaltHandlebelopPrAarOgMaaned.add(sumMonth);
            }
        }
        catch (SQLException e) {
            this.logWarning("Got error when retrieving total amount used per year", e);
        }
        return totaltHandlebelopPrAarOgMaaned;
    }

    public List<Favoritt> finnFavoritter(String brukernavn) {
        ArrayList<Favoritt> favoritter = new ArrayList<Favoritt>();
        String sql = "select s.store_id, s.store_name, s.gruppe, s.rekkefolge as store_rekkefolge, f.favourite_id, f.account_id, f.rekkefolge favourite_rekkefolge from accounts a join favourites f on a.account_id=f.account_id join stores s on f.store_id=s.store_id where a.username=? order by f.rekkefolge";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, brukernavn);
            try (ResultSet results = statement.executeQuery();){
                while (results.next()) {
                    Butikk butikk = Butikk.with().storeId(results.getInt(STORE_ID)).butikknavn(results.getString(STORE_NAME)).gruppe(results.getInt(GRUPPE)).rekkefolge(results.getInt("store_rekkefolge")).build();
                    Favoritt favoritt = Favoritt.with().favouriteid(results.getInt("favourite_id")).accountid(results.getInt(ACCOUNT_ID)).store(butikk).rekkefolge(results.getInt("favourite_rekkefolge")).build();
                    favoritter.add(favoritt);
                }
            }
        }
        catch (SQLException e) {
            throw new HandleregException("Failed to retrieve a list of favourites", (Throwable)e);
        }
        return favoritter;
    }

    public List<Favoritt> leggTilFavoritt(NyFavoritt nyFavoritt) {
        try (Connection connection = this.datasource.getConnection();){
            int sisteRekkefolge = this.finnSisteRekkefolgeIBrukersFavoritter(connection, nyFavoritt.brukernavn());
            String sql = "insert into favourites (account_id, store_id, rekkefolge) values ((select account_id from accounts where username=?), ?, ?)";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, nyFavoritt.brukernavn());
                statement.setInt(2, nyFavoritt.butikk().storeId());
                statement.setInt(3, sisteRekkefolge + 1);
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new HandleregException("Failed to insert a new favourite", (Throwable)e);
        }
        return this.finnFavoritter(nyFavoritt.brukernavn());
    }

    public List<Favoritt> slettFavoritt(Favoritt skalSlettes) {
        try (Connection connection = this.datasource.getConnection();){
            String sql = "delete from favourites where favourite_id=?";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, skalSlettes.favouriteid());
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new HandleregException("Failed to delete favourite", (Throwable)e);
        }
        return this.finnFavoritterMedAccountid(skalSlettes.accountid());
    }

    public List<Favoritt> byttRekkefolge(Favorittpar parSomSkalBytteRekkfolge) {
        try (Connection connection = this.datasource.getConnection();){
            String sql = "update favourites set rekkefolge=? where favourite_id=?";
            try (PreparedStatement flipstatement1 = connection.prepareStatement(sql);){
                flipstatement1.setInt(1, parSomSkalBytteRekkfolge.andre().rekkefolge());
                flipstatement1.setInt(2, parSomSkalBytteRekkfolge.forste().favouriteid());
                flipstatement1.executeUpdate();
            }
            try (PreparedStatement flipstatement2 = connection.prepareStatement(sql);){
                flipstatement2.setInt(1, parSomSkalBytteRekkfolge.forste().rekkefolge());
                flipstatement2.setInt(2, parSomSkalBytteRekkfolge.andre().favouriteid());
                flipstatement2.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new HandleregException("Failed to swap order of favourites", (Throwable)e);
        }
        return this.finnFavoritterMedAccountid(parSomSkalBytteRekkfolge.forste().accountid());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int finnNesteLedigeRekkefolgeForGruppe(int gruppe) {
        String sql = "select rekkefolge from stores where gruppe=? order by rekkefolge desc fetch next 1 rows only";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, gruppe);
            try (ResultSet results = statement.executeQuery();){
                if (!results.next()) return 0;
                int sortorderValueOfLastStore = results.getInt(REKKEFOLGE);
                int n = sortorderValueOfLastStore + 10;
                return n;
            }
        }
        catch (SQLException e) {
            String message = String.format("Failed to retrieve the next store sort order value for group %d", gruppe);
            this.logError(message, e);
            throw new HandleregException(message, (Throwable)e);
        }
    }

    List<Favoritt> finnFavoritterMedAccountid(int accountid) {
        ArrayList<Favoritt> favoritter = new ArrayList<Favoritt>();
        String sql = "select s.store_id, s.store_name, s.gruppe as store_gruppe, s.rekkefolge as store_rekkefolge, f.favourite_id, f.account_id, f.rekkefolge as favourite_rekkefolge from favourites f join stores s on f.store_id=s.store_id where f.account_id=? order by f.rekkefolge";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, accountid);
            try (ResultSet results = statement.executeQuery();){
                while (results.next()) {
                    Butikk butikk = Butikk.with().storeId(results.getInt(STORE_ID)).butikknavn(results.getString(STORE_NAME)).gruppe(results.getInt("store_gruppe")).rekkefolge(results.getInt("store_rekkefolge")).build();
                    Favoritt favoritt = Favoritt.with().favouriteid(results.getInt("favourite_id")).accountid(results.getInt(ACCOUNT_ID)).store(butikk).rekkefolge(results.getInt("favourite_rekkefolge")).build();
                    favoritter.add(favoritt);
                }
            }
        }
        catch (SQLException e) {
            throw new HandleregException("Failed to retrieve a list of favourites", (Throwable)e);
        }
        return favoritter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int finnSisteRekkefolgeIBrukersFavoritter(Connection connection, String brukernavn) {
        String sql = "select rekkefolge from accounts a join favourites f on a.account_id=f.account_id where a.username=? order by f.rekkefolge desc";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, brukernavn);
            try (ResultSet results = statement.executeQuery();){
                if (!results.next()) return 0;
                int n = results.getInt(REKKEFOLGE);
                return n;
            }
        }
        catch (SQLException e) {
            this.logWarning("Failed to retrieve last favourite rekkefolge value", e);
        }
        return 0;
    }

    private void addRolesIfNotpresent() {
        String handleregbruker = "handleregbruker";
        List roles = this.useradmin.getRoles();
        Optional<Role> existingRole = roles.stream().filter(r -> handleregbruker.equals(r.rolename())).findFirst();
        if (!existingRole.isPresent()) {
            this.useradmin.addRole(Role.with().id(-1).rolename(handleregbruker).description("Bruker av applikasjonen handlereg").build());
        }
    }

    private void logError(String message, SQLException e) {
        this.logger.error(message, (Object)e);
    }

    private void logWarning(String message, SQLException e) {
        this.logger.warn(message, (Object)e);
    }
}

