/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.handlereg.db.liquibase.production;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import no.priv.bang.handlereg.db.liquibase.HandleregLiquibase;
import no.priv.bang.handlereg.services.HandleregException;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Component(immediate=true, property={"name=handleregdb"})
public class HandleregProductionDbLiquibaseRunner
implements PreHook {
    private Logger logger;

    @Reference
    public void setLogService(LogService logservice) {
        this.logger = logservice.getLogger(HandleregProductionDbLiquibaseRunner.class);
    }

    @Activate
    public void activate() {
    }

    public void prepare(DataSource datasource) throws SQLException {
        Connection connect;
        HandleregLiquibase handleregLiquibase = new HandleregLiquibase();
        try {
            connect = datasource.getConnection();
            try {
                handleregLiquibase.createInitialSchema(connect);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (Exception e) {
            this.logError("Failed to create initial schema of handlereg PostgreSQL database", e);
        }
        connect = datasource.getConnection();
        try {
            this.insertMockData(connect, handleregLiquibase);
        }
        finally {
            if (connect != null) {
                connect.close();
            }
        }
        try {
            connect = datasource.getConnection();
            try {
                handleregLiquibase.updateSchema(connect);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (Exception e) {
            this.logError("Failed to update schema of handlereg PostgreSQL database", e);
        }
    }

    public void insertMockData(Connection connect, HandleregLiquibase liquibase) {
        try {
            liquibase.applyLiquibaseChangelist(connect, "sql/data/db-changelog.xml", this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new HandleregException("Error inserting initial data in handlereg postgresql database", (Throwable)e);
        }
    }

    private void logError(String message, Exception exception) {
        this.logger.error(message, (Object)exception);
    }
}

