/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.handlereg.db.liquibase.test;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import no.priv.bang.handlereg.db.liquibase.HandleregLiquibase;
import no.priv.bang.handlereg.services.HandleregException;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Component(immediate=true, property={"name=handleregdb"})
public class HandleregTestDbLiquibaseRunner
implements PreHook {
    private Logger logger;

    @Reference
    public void setLogService(LogService logservice) {
        this.logger = logservice.getLogger(HandleregTestDbLiquibaseRunner.class);
    }

    @Activate
    public void activate() {
    }

    public void prepare(DataSource datasource) throws SQLException {
        Connection connect;
        HandleregLiquibase handleregLiquibase = new HandleregLiquibase();
        try {
            connect = datasource.getConnection();
            try {
                handleregLiquibase.createInitialSchema(connect);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (LiquibaseException e) {
            this.logger.error("Error creating initial schema in handlereg test database", (Object)e);
        }
        connect = datasource.getConnection();
        try {
            this.insertMockData(connect, handleregLiquibase);
        }
        finally {
            if (connect != null) {
                connect.close();
            }
        }
        try {
            connect = datasource.getConnection();
            try {
                handleregLiquibase.updateSchema(connect);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (LiquibaseException e) {
            this.logger.error("Error updating schema in handlereg test database", (Object)e);
        }
    }

    public void insertMockData(Connection connect, HandleregLiquibase liquibase) {
        try {
            liquibase.applyLiquibaseChangelist(connect, "sql/data/db-changelog.xml", this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new HandleregException("Error inserting mock data in handlereg derby test database", (Throwable)e);
        }
    }
}

