/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.handlereg.web.api.resources;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import no.priv.bang.handlereg.services.Butikk;
import no.priv.bang.handlereg.services.HandleregService;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="")
@Produces(value={"application/json"})
@RequiresUser
@RequiresRoles(value={"handleregbruker"})
public class ButikkResource {
    private static final String SEE_THE_LOG_FOR_DETAILS = ", see the log for details";
    private Logger logger;
    @Inject
    HandleregService handlereg;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(ButikkResource.class);
    }

    @GET
    @Path(value="/butikker")
    public List<Butikk> getButikker() {
        try {
            return this.handlereg.finnButikker();
        }
        catch (Exception e) {
            String message = "Failed to find the list of stores";
            this.logger.error(message, (Object)e);
            throw new InternalServerErrorException(message + SEE_THE_LOG_FOR_DETAILS);
        }
    }

    @POST
    @Path(value="/nybutikk")
    @Consumes(value={"application/json"})
    public List<Butikk> leggTilButikk(Butikk nybutikk) {
        try {
            return this.handlereg.leggTilButikk(nybutikk);
        }
        catch (Exception e) {
            String message = "Failed to add a new store";
            this.logger.error(message, (Object)e);
            throw new InternalServerErrorException(message + SEE_THE_LOG_FOR_DETAILS);
        }
    }

    @POST
    @Path(value="/endrebutikk")
    @Consumes(value={"application/json"})
    public List<Butikk> endreButikk(Butikk endretbutikk) {
        try {
            return this.handlereg.endreButikk(endretbutikk);
        }
        catch (Exception e) {
            String message = "Failed to change a store";
            this.logger.error(message, (Object)e);
            throw new InternalServerErrorException(message + SEE_THE_LOG_FOR_DETAILS);
        }
    }
}

