/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.handlereg.web.api.resources;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import no.priv.bang.handlereg.services.Favoritt;
import no.priv.bang.handlereg.services.Favorittpar;
import no.priv.bang.handlereg.services.HandleregService;
import no.priv.bang.handlereg.services.NyFavoritt;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;

@Path(value="")
@Produces(value={"application/json"})
@RequiresUser
@RequiresRoles(value={"handleregbruker"})
public class FavorittResource {
    @Inject
    HandleregService handlereg;

    @GET
    @Path(value="favoritter")
    public List<Favoritt> getFavoritter(@QueryParam(value="username") String username) {
        return this.handlereg.finnFavoritter(username);
    }

    @POST
    @Path(value="favoritt/leggtil")
    @Consumes(value={"application/json"})
    public List<Favoritt> leggTilFavoritt(NyFavoritt nyFavoritt) {
        return this.handlereg.leggTilFavoritt(nyFavoritt);
    }

    @POST
    @Path(value="favoritt/slett")
    @Consumes(value={"application/json"})
    public List<Favoritt> slettFavoritt(Favoritt favorittSomSkalSlettes) {
        return this.handlereg.slettFavoritt(favorittSomSkalSlettes);
    }

    @POST
    @Path(value="favoritter/bytt")
    @Consumes(value={"application/json"})
    public List<Favoritt> byttRekkefolge(Favorittpar favoritterSomSkalBytteRekkefolge) {
        return this.handlereg.byttRekkefolge(favoritterSomSkalBytteRekkefolge);
    }
}

