/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.handlereg.web.api.resources;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import no.priv.bang.handlereg.services.HandleregService;
import no.priv.bang.handlereg.services.NyHandling;
import no.priv.bang.handlereg.services.Oversikt;
import no.priv.bang.handlereg.services.Transaction;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="")
@Produces(value={"application/json"})
@RequiresUser
@RequiresRoles(value={"handleregbruker"})
public class HandlingResource {
    private Logger logger;
    @Inject
    HandleregService handlereg;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(HandlingResource.class);
    }

    @GET
    @Path(value="/handlinger/{accountid}")
    public List<Transaction> getHandlinger(@PathParam(value="accountid") int accountId, @DefaultValue(value="1") @QueryParam(value="pagenumber") int pageNumber, @DefaultValue(value="10") @QueryParam(value="pagesize") int pageSize) {
        try {
            return this.handlereg.findTransactions(accountId, pageNumber, pageSize);
        }
        catch (Exception e) {
            String message = String.format("Failed to get transactions for account %d", accountId);
            this.logger.error(message, (Object)e);
            throw new InternalServerErrorException(message + ", see the log for details");
        }
    }

    @POST
    @Path(value="/nyhandling")
    @Consumes(value={"application/json"})
    public Oversikt nyhandling(NyHandling handling) {
        try {
            return this.handlereg.registrerHandling(handling);
        }
        catch (Exception e) {
            String message = "Failed to add transaction";
            this.logger.error(message, (Object)e);
            throw new InternalServerErrorException(message + ", see the log for details");
        }
    }
}

