/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.handlereg.web.api.resources;

import java.util.Base64;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import no.priv.bang.handlereg.services.Credentials;
import no.priv.bang.handlereg.services.Loginresultat;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.SavedRequest;
import org.apache.shiro.web.util.WebUtils;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LoginResource {
    private Logger logger;
    @Context
    ServletContext webcontext;
    @Context
    HttpServletRequest request;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(LoginResource.class);
    }

    @POST
    @Path(value="/login")
    public Loginresultat login(Credentials credentials) {
        Subject subject = SecurityUtils.getSubject();
        String decodedPassword = new String(Base64.getDecoder().decode(credentials.password()));
        UsernamePasswordToken token = new UsernamePasswordToken(credentials.username(), decodedPassword, true);
        try {
            subject.login((AuthenticationToken)token);
            Optional<SavedRequest> savedRequest = Optional.ofNullable(WebUtils.getSavedRequest((ServletRequest)this.request));
            String contextpath = this.webcontext.getContextPath();
            String originalRequestUrl = savedRequest.map(SavedRequest::getRequestUrl).map(url -> url.replace(contextpath, "")).orElse("/");
            Loginresultat loginresultat = Loginresultat.with().suksess(true).feilmelding("").authorized(subject.hasRole("handleregbruker")).originalRequestUrl(originalRequestUrl).brukernavn((String)subject.getPrincipal()).build();
            return loginresultat;
        }
        catch (UnknownAccountException e) {
            this.logger.warn("Login error: unknown account", (Object)e);
            Loginresultat loginresultat = Loginresultat.with().suksess(false).feilmelding("Ukjent konto").build();
            return loginresultat;
        }
        catch (IncorrectCredentialsException e) {
            this.logger.warn("Login error: wrong password", (Object)e);
            Loginresultat loginresultat = Loginresultat.with().suksess(false).feilmelding("Feil passord").build();
            return loginresultat;
        }
        catch (ExcessiveAttemptsException e) {
            this.logger.warn("Login error: locked account", (Object)e);
            Loginresultat loginresultat = Loginresultat.with().suksess(false).feilmelding("Grense for feilede innlogginger n\u00e5dd og konto er l\u00e5st. Vennligst kontakt systemadministrator").build();
            return loginresultat;
        }
        catch (LockedAccountException e) {
            this.logger.warn("Login error: locked account", (Object)e);
            Loginresultat loginresultat = Loginresultat.with().suksess(false).feilmelding("L\u00e5st konto").build();
            return loginresultat;
        }
        catch (AuthenticationException e) {
            this.logger.warn("Login error: general authentication error", (Object)e);
            Loginresultat loginresultat = Loginresultat.with().suksess(false).feilmelding("Ukjent feil").build();
            return loginresultat;
        }
        catch (Exception e) {
            this.logger.error("Login error: internal server error", (Object)e);
            throw new InternalServerErrorException();
        }
        finally {
            token.clear();
        }
    }

    @GET
    @Path(value="/logout")
    @RequiresUser
    public Loginresultat logout() {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return Loginresultat.with().suksess(false).feilmelding("Logget ut").build();
    }

    @GET
    @Path(value="/logintilstand")
    public Loginresultat logintilstand() {
        Subject subject = SecurityUtils.getSubject();
        boolean suksess = subject.isAuthenticated();
        boolean harRoleHandleregbruker = subject.hasRole("handleregbruker");
        String brukerLoggetInnMelding = harRoleHandleregbruker ? "Bruker er logget inn og har tilgang" : "Bruker er logget inn men mangler tilgang";
        String melding = suksess ? brukerLoggetInnMelding : "Bruker er ikke logget inn";
        return Loginresultat.with().suksess(suksess).feilmelding(melding).authorized(harRoleHandleregbruker).brukernavn((String)subject.getPrincipal()).build();
    }
}

