/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.handlereg.web.api.resources;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import no.priv.bang.handlereg.services.HandleregService;
import no.priv.bang.handlereg.services.Oversikt;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.subject.Subject;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="/oversikt")
@Produces(value={"application/json"})
@RequiresUser
@RequiresRoles(value={"handleregbruker"})
public class OversiktResource {
    private Logger logger;
    @Inject
    HandleregService handlereg;

    @Inject
    public void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(OversiktResource.class);
    }

    @GET
    public Oversikt get() {
        try {
            Subject subject = SecurityUtils.getSubject();
            String brukernavn = (String)subject.getPrincipal();
            return this.handlereg.finnOversikt(brukernavn);
        }
        catch (Exception e) {
            String message = "Failed to get Oversikt in handlereg";
            this.logger.error(message, (Object)e);
            throw new InternalServerErrorException(message + ", see the log for details");
        }
    }
}

