/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.oldalbum.db.liquibase.test;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import no.priv.bang.oldalbum.db.liquibase.OldAlbumLiquibase;
import no.priv.bang.osgi.service.adapters.logservice.LogServiceAdapter;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;

@Component(immediate=true, property={"name=oldalbum"})
public class OldAlbumDerbyTestDatabase
implements PreHook {
    LogServiceAdapter logservice = new LogServiceAdapter();

    @Reference
    public void setLogService(LogService logservice) {
        this.logservice.setLogService(logservice);
    }

    @Activate
    public void activate() {
    }

    public void prepare(DataSource datasource) throws SQLException {
        this.createInitialSchema(datasource);
        this.insertMockData(datasource);
    }

    void createInitialSchema(DataSource datasource) throws SQLException {
        try (Connection connect = datasource.getConnection();){
            OldAlbumLiquibase handleregLiquibase = new OldAlbumLiquibase();
            handleregLiquibase.createInitialSchema(connect);
        }
        catch (LiquibaseException e) {
            this.logservice.log(1, "Error creating handlreg test database", (Throwable)e);
        }
    }

    void insertMockData(DataSource datasource) throws SQLException {
        try (Connection connect = datasource.getConnection();){
            JdbcConnection databaseConnection = new JdbcConnection(connect);
            ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
            Liquibase liquibase = new Liquibase("oldalbum/sql/data/db-changelog.xml", (ResourceAccessor)classLoaderResourceAccessor, (DatabaseConnection)databaseConnection);
            liquibase.update("");
        }
        catch (LiquibaseException e) {
            this.logservice.log(1, "Error populating dummy data database", (Throwable)e);
        }
    }
}

