/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.oldalbum.web.api.resources;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import no.priv.bang.oldalbum.services.bean.Credentials;
import no.priv.bang.oldalbum.services.bean.LoginResult;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;
import org.osgi.service.log.LogService;

@Path(value="")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LoginResource {
    @Inject
    LogService logservice;

    @GET
    @Path(value="/login")
    public LoginResult loginCheck() {
        Subject subject = SecurityUtils.getSubject();
        boolean remembered = subject.isAuthenticated();
        boolean canModifyAlbum = this.checkIfUserCanModifyAlbum(subject);
        return new LoginResult(remembered, (String)subject.getPrincipal(), "", canModifyAlbum);
    }

    @POST
    @Path(value="/login")
    public LoginResult login(Credentials credentials) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(credentials.getUsername(), credentials.getPassword().toCharArray(), true);
        try {
            subject.login((AuthenticationToken)token);
            boolean canModifyAlbum = this.checkIfUserCanModifyAlbum(subject);
            LoginResult loginResult = new LoginResult(true, (String)subject.getPrincipal(), "", canModifyAlbum);
            return loginResult;
        }
        catch (UnknownAccountException e) {
            this.logservice.log(2, "Login error: unknown account", (Throwable)e);
            LoginResult loginResult = new LoginResult(false, null, "Unknown account", false);
            return loginResult;
        }
        catch (IncorrectCredentialsException e) {
            this.logservice.log(2, "Login error: wrong password", (Throwable)e);
            LoginResult loginResult = new LoginResult(false, null, "Wrong password", false);
            return loginResult;
        }
        catch (LockedAccountException e) {
            this.logservice.log(2, "Login error: locked account", (Throwable)e);
            LoginResult loginResult = new LoginResult(false, null, "Locked account", false);
            return loginResult;
        }
        catch (AuthenticationException e) {
            this.logservice.log(2, "Login error: general authentication error", (Throwable)e);
            LoginResult loginResult = new LoginResult(false, null, "Unknown login error", false);
            return loginResult;
        }
        catch (Exception e) {
            this.logservice.log(1, "Login error: internal server error", (Throwable)e);
            throw new InternalServerErrorException();
        }
        finally {
            token.clear();
        }
    }

    @GET
    @Path(value="/logout")
    public LoginResult logout(Credentials credentials) {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return new LoginResult(false, null, "Logged out", false);
    }

    private boolean checkIfUserCanModifyAlbum(Subject subject) {
        try {
            subject.checkRole("oldalbumadmin");
            return true;
        }
        catch (AuthorizationException authorizationException) {
            return false;
        }
    }
}

