/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sampleapp.backend;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import no.priv.bang.osgiservice.users.Role;
import no.priv.bang.osgiservice.users.User;
import no.priv.bang.osgiservice.users.UserManagementService;
import no.priv.bang.sampleapp.services.SampleappService;
import no.priv.bang.sampleapp.services.beans.Account;
import no.priv.bang.sampleapp.services.beans.CounterBean;
import no.priv.bang.sampleapp.services.beans.CounterIncrementStepBean;
import no.priv.bang.sampleapp.services.beans.LocaleBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Component(service={SampleappService.class}, immediate=true, property={"defaultlocale=nb_NO"})
public class SampleappServiceProvider
implements SampleappService {
    private static final String DISPLAY_TEXT_RESOURCES = "i18n.Texts";
    private Logger logger;
    private DataSource datasource;
    private UserManagementService useradmin;
    private Locale defaultLocale;

    @Reference
    public void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(SampleappServiceProvider.class);
    }

    @Reference(target="(osgi.jndi.service.name=jdbc/sampleapp)")
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Reference
    public void setUseradmin(UserManagementService useradmin) {
        this.useradmin = useradmin;
    }

    @Activate
    public void activate(Map<String, Object> config) {
        this.defaultLocale = Locale.forLanguageTag(((String)config.get("defaultlocale")).replace('_', '-'));
        this.addRolesIfNotpresent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean lazilyCreateAccount(String username) {
        try (Connection connection = this.datasource.getConnection();){
            int accountid = this.findAccount(connection, username);
            if (accountid != -1) {
                boolean bl2 = false;
                return bl2;
            }
            try (PreparedStatement createAccount = connection.prepareStatement("insert into sampleapp_accounts (username) values (?)");){
                createAccount.setString(1, username);
                createAccount.executeUpdate();
            }
            accountid = this.findAccount(connection, username);
            try (PreparedStatement createIncrementStep = connection.prepareStatement("insert into counter_increment_steps (account_id) values (?)");){
                createIncrementStep.setInt(1, accountid);
                createIncrementStep.executeUpdate();
            }
            try (PreparedStatement createCounter = connection.prepareStatement("insert into counters (account_id) values (?)");){
                createCounter.setInt(1, accountid);
                createCounter.executeUpdate();
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.warn("Failed to create sampleapp account for username \"{}\"", (Object)username, (Object)e);
            return false;
        }
    }

    public List<Account> getAccounts() {
        ArrayList<Account> accounts = new ArrayList<Account>();
        try (Connection connection = this.datasource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet results = statement.executeQuery("select account_id, username from sampleapp_accounts");){
            while (results.next()) {
                int accountId = results.getInt("account_id");
                String username = results.getString("username");
                User user = this.useradmin.getUser(username);
                Account account = Account.with().accountId(accountId).user(user).build();
                accounts.add(account);
            }
        }
        catch (SQLException e) {
            this.logger.error("Ingen sampleapp", (Object)e);
        }
        return accounts;
    }

    public Optional<CounterIncrementStepBean> getCounterIncrementStep(String username) {
        Optional<CounterIncrementStepBean> optional;
        block8: {
            Connection connection = this.datasource.getConnection();
            try {
                optional = this.findCounterIncrementStep(connection, username).map(step -> CounterIncrementStepBean.with().username(username).counterIncrementStep(step.intValue()).build());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.error("No increment steps could be found for user \"{}\"", (Object)username, (Object)e);
                    return Optional.empty();
                }
            }
            connection.close();
        }
        return optional;
    }

    public Optional<CounterIncrementStepBean> updateCounterIncrementStep(CounterIncrementStepBean updatedIncrementStep) {
        String username = updatedIncrementStep.username();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("update counter_increment_steps set counter_increment_step=? where account_id in (select account_id from sampleapp_accounts where username=?)");){
            statement.setInt(1, updatedIncrementStep.counterIncrementStep());
            statement.setString(2, username);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("Unable to update increment step for user \"{}\"", (Object)username, (Object)e);
            return Optional.empty();
        }
        return this.getCounterIncrementStep(username);
    }

    public Optional<CounterBean> getCounter(String username) {
        Optional<CounterBean> optional;
        block8: {
            Connection connection = this.datasource.getConnection();
            try {
                optional = this.findAndCreateCounterBean(connection, username);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.error("No counter could be found for user \"{}\"", (Object)username, (Object)e);
                    return Optional.empty();
                }
            }
            connection.close();
        }
        return optional;
    }

    public Optional<CounterBean> incrementCounter(String username) {
        Optional<CounterBean> optional;
        block15: {
            Connection connection = this.datasource.getConnection();
            try {
                Integer incrementStep = this.findCounterIncrementStep(connection, username).orElse(0);
                Integer updatedcounter = this.findCounter(connection, username).map(counter -> counter + incrementStep).orElse(0);
                try (PreparedStatement statement = connection.prepareStatement("update counters set counter=? where account_id in (select account_id from sampleapp_accounts where username=?)");){
                    statement.setInt(1, updatedcounter);
                    statement.setString(2, username);
                    statement.executeUpdate();
                }
                optional = this.findAndCreateCounterBean(connection, username);
                if (connection == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.warn("Failed to increment counter for user \"{}\"", (Object)username, (Object)e);
                    return Optional.empty();
                }
            }
            connection.close();
        }
        return optional;
    }

    public Optional<CounterBean> decrementCounter(String username) {
        Optional<CounterBean> optional;
        block15: {
            Connection connection = this.datasource.getConnection();
            try {
                Integer incrementStep = this.findCounterIncrementStep(connection, username).orElse(0);
                Integer updatedCounter = this.findCounter(connection, username).map(counter -> counter - incrementStep).orElse(0);
                try (PreparedStatement statement = connection.prepareStatement("update counters set counter=? where account_id in (select account_id from sampleapp_accounts where username=?)");){
                    statement.setInt(1, updatedCounter);
                    statement.setString(2, username);
                    statement.executeUpdate();
                }
                optional = this.findAndCreateCounterBean(connection, username);
                if (connection == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.warn("Failed to decrement counter for user \"{}\"", (Object)username, (Object)e);
                    return Optional.empty();
                }
            }
            connection.close();
        }
        return optional;
    }

    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    public List<LocaleBean> availableLocales() {
        return Arrays.asList(Locale.forLanguageTag("nb-NO"), Locale.UK).stream().map(l -> LocaleBean.with().locale(l).build()).toList();
    }

    public Map<String, String> displayTexts(Locale locale) {
        return this.transformResourceBundleToMap(locale);
    }

    public String displayText(String key, String locale) {
        Locale active = locale == null || locale.isEmpty() ? this.defaultLocale : Locale.forLanguageTag(locale.replace('_', '-'));
        ResourceBundle bundle = ResourceBundle.getBundle(DISPLAY_TEXT_RESOURCES, active);
        return bundle.getString(key);
    }

    private int findAccount(Connection connection, String username) throws SQLException {
        try (PreparedStatement findAccount = connection.prepareStatement("select account_id from sampleapp_accounts where username=?");){
            findAccount.setString(1, username);
            try (ResultSet results = findAccount.executeQuery();){
                if (results.next()) {
                    int n = results.getInt("account_id");
                    return n;
                }
            }
        }
        return -1;
    }

    private Optional<Integer> findCounterIncrementStep(Connection connection, String username) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("select counter_increment_step from counter_increment_steps c join sampleapp_accounts a on c.account_id=a.account_id where a.username=?");){
            statement.setString(1, username);
            try (ResultSet results = statement.executeQuery();){
                if (results.next()) {
                    Optional<Integer> optional = Optional.of(results.getInt("counter_increment_step"));
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    private Optional<Integer> findCounter(Connection connection, String username) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("select counter from counters c join sampleapp_accounts a on c.account_id=a.account_id where a.username=?");){
            statement.setString(1, username);
            try (ResultSet results = statement.executeQuery();){
                if (results.next()) {
                    Optional<Integer> optional = Optional.of(results.getInt("counter"));
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    private Optional<CounterBean> findAndCreateCounterBean(Connection connection, String username) throws SQLException {
        return this.findCounter(connection, username).map(c -> CounterBean.with().counter(c.intValue()).build());
    }

    private void addRolesIfNotpresent() {
        Map<String, String> sampleapproles = Map.of("sampleappuser", "Bruker av applikasjonen sampleapp");
        Set existingroles = this.useradmin.getRoles().stream().map(Role::rolename).collect(Collectors.toSet());
        sampleapproles.entrySet().stream().filter(r -> !existingroles.contains(r.getKey())).forEach(r -> this.useradmin.addRole(Role.with().id(-1).rolename((String)r.getKey()).description((String)r.getValue()).build()));
    }

    Map<String, String> transformResourceBundleToMap(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        ResourceBundle bundle = ResourceBundle.getBundle(DISPLAY_TEXT_RESOURCES, locale);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, bundle.getString(key));
        }
        return map;
    }
}

