/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sampleapp.db.liquibase.production;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import no.priv.bang.sampleapp.db.liquibase.SampleappLiquibase;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"name=sampleappdb"})
public class SampleappProductionDbLiquibaseRunner
implements PreHook {
    @Activate
    public void activate() {
    }

    public void prepare(DataSource datasource) throws SQLException {
        Connection connect;
        SampleappLiquibase sampleappLiquibase = new SampleappLiquibase();
        try {
            connect = datasource.getConnection();
            try {
                sampleappLiquibase.createInitialSchema(connect);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Failed to create schema in sampleapp PostgreSQL database", e);
        }
        try {
            connect = datasource.getConnection();
            try {
                this.insertInitialData(connect, sampleappLiquibase);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (Exception e) {
            throw new SQLException("Failed to insert initial data into sampleapp PostgreSQL database", e);
        }
        try {
            connect = datasource.getConnection();
            try {
                sampleappLiquibase.updateSchema(connect);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Failed to modify schema of sampleapp PostgreSQL database", e);
        }
    }

    public void insertInitialData(Connection connect, SampleappLiquibase sampleappLiquibase) throws LiquibaseException {
        sampleappLiquibase.applyLiquibaseChangelist(connect, "sql/data/db-changelog.xml", this.getClass().getClassLoader());
    }
}

