/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sampleapp.db.liquibase.test;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import no.priv.bang.sampleapp.db.liquibase.SampleappLiquibase;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"name=sampleappdb"})
public class SampleappTestDbLiquibaseRunner
implements PreHook {
    @Activate
    public void activate() {
    }

    public void prepare(DataSource datasource) throws SQLException {
        Connection connect;
        SampleappLiquibase sampleappLiquibase = new SampleappLiquibase();
        try {
            connect = datasource.getConnection();
            try {
                sampleappLiquibase.createInitialSchema(connect);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Error creating sampleapp test database schema", e);
        }
        try {
            connect = datasource.getConnection();
            try {
                this.insertMockData(connect, sampleappLiquibase);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (Exception e) {
            throw new SQLException("Error inserting sampleapp test database mock data", e);
        }
        try {
            connect = datasource.getConnection();
            try {
                sampleappLiquibase.updateSchema(connect);
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Error updating sampleapp test database schema", e);
        }
    }

    public void insertMockData(Connection connect, SampleappLiquibase sampleappLiquibase) throws LiquibaseException {
        sampleappLiquibase.applyLiquibaseChangelist(connect, "sql/data/db-changelog.xml", this.getClass().getClassLoader());
    }
}

