/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sampleapp.web.api.resources;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import no.priv.bang.sampleapp.services.SampleappService;
import no.priv.bang.sampleapp.services.beans.CounterBean;
import no.priv.bang.sampleapp.services.beans.CounterIncrementStepBean;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;

@Path(value="counter")
@Produces(value={"application/json"})
@RequiresUser
@RequiresRoles(value={"sampleappuser"})
public class CounterResource {
    @Inject
    SampleappService sampleapp;

    @GET
    @Path(value="incrementstep/{username}")
    public CounterIncrementStepBean getCounterIncrementStep(@PathParam(value="username") String username) {
        return (CounterIncrementStepBean)this.sampleapp.getCounterIncrementStep(username).orElseThrow(NotFoundException::new);
    }

    @POST
    @Path(value="incrementstep")
    @Consumes(value={"application/json"})
    public CounterIncrementStepBean updateCounterIncrementStep(CounterIncrementStepBean updateIncrementStep) {
        return (CounterIncrementStepBean)this.sampleapp.updateCounterIncrementStep(updateIncrementStep).orElseThrow(InternalServerErrorException::new);
    }

    @GET
    @Path(value="{username}")
    public CounterBean getCounter(@PathParam(value="username") String username) {
        return (CounterBean)this.sampleapp.getCounter(username).orElseThrow(NotFoundException::new);
    }

    @GET
    @Path(value="{username}/increment")
    public CounterBean incrementCounter(@PathParam(value="username") String username) {
        return (CounterBean)this.sampleapp.incrementCounter(username).orElseThrow(InternalServerErrorException::new);
    }

    @GET
    @Path(value="{username}/decrement")
    public CounterBean decrementCounter(@PathParam(value="username") String username) {
        return (CounterBean)this.sampleapp.decrementCounter(username).orElseThrow(InternalServerErrorException::new);
    }
}

