/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sampleapp.web.api.resources;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import no.priv.bang.sampleapp.services.SampleappService;
import no.priv.bang.sampleapp.services.beans.LocaleBean;
import no.priv.bang.sampleapp.web.api.resources.ResourceBase;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="")
public class LocalizationResource
extends ResourceBase {
    @Inject
    SampleappService sampleapp;
    Logger logger;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(this.getClass());
    }

    @GET
    @Path(value="defaultlocale")
    @Produces(value={"application/json"})
    public Locale defaultLocale() {
        return this.sampleapp.defaultLocale();
    }

    @GET
    @Path(value="availablelocales")
    @Produces(value={"application/json"})
    public List<LocaleBean> availableLocales() {
        return this.sampleapp.availableLocales();
    }

    @GET
    @Path(value="displaytexts")
    @Produces(value={"application/json"})
    public Map<String, String> displayTexts(@QueryParam(value="locale") String locale) {
        try {
            return this.sampleapp.displayTexts(Locale.forLanguageTag(locale.replace('_', '-')));
        }
        catch (MissingResourceException e) {
            String message = String.format("Unknown locale '%s' used when fetching GUI texts", locale);
            this.logger.error(message);
            throw new WebApplicationException(this.response(500, message));
        }
    }
}

