/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sampleapp.web.api.resources;

import java.util.Base64;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import no.priv.bang.authservice.definitions.AuthserviceException;
import no.priv.bang.osgiservice.users.User;
import no.priv.bang.osgiservice.users.UserManagementService;
import no.priv.bang.sampleapp.services.SampleappService;
import no.priv.bang.sampleapp.services.beans.Credentials;
import no.priv.bang.sampleapp.services.beans.Loginresult;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.SavedRequest;
import org.apache.shiro.web.util.WebUtils;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LoginResource {
    private Logger logger;
    @Inject
    ServletContext webcontext;
    @Context
    HttpServletRequest request;
    @Inject
    SampleappService sampleapp;
    @Inject
    UserManagementService useradmin;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(LoginResource.class);
    }

    @POST
    @Path(value="/login")
    public Loginresult login(@QueryParam(value="locale") String locale, Credentials credentials) {
        Subject subject = SecurityUtils.getSubject();
        String username = credentials.username();
        String decodedPassword = new String(Base64.getDecoder().decode(credentials.password()));
        UsernamePasswordToken token = new UsernamePasswordToken(username, decodedPassword, true);
        try {
            subject.login((AuthenticationToken)token);
            Optional<SavedRequest> savedRequest = Optional.ofNullable(WebUtils.getSavedRequest((ServletRequest)this.request));
            String contextpath = this.webcontext.getContextPath();
            String originalRequestUrl = savedRequest.map(SavedRequest::getRequestUrl).map(url -> url.replace(contextpath, "")).orElse("/");
            boolean authorized = subject.hasRole("sampleappuser");
            if (authorized) {
                this.sampleapp.lazilyCreateAccount(username);
            }
            User user = this.useradmin.getUser(username);
            Loginresult loginresult = Loginresult.with().success(true).errormessage("").authorized(authorized).user(user).originalRequestUrl(originalRequestUrl).build();
            return loginresult;
        }
        catch (UnknownAccountException e) {
            this.logger.warn("Login error: unknown account", (Object)e);
            Loginresult loginresult = Loginresult.with().success(false).errormessage(this.sampleapp.displayText("unknownaccount", locale)).build();
            return loginresult;
        }
        catch (IncorrectCredentialsException e) {
            this.logger.warn("Login error: wrong password", (Object)e);
            Loginresult loginresult = Loginresult.with().success(false).errormessage(this.sampleapp.displayText("wrongpassword", locale)).build();
            return loginresult;
        }
        catch (LockedAccountException e) {
            this.logger.warn("Login error: locked account", (Object)e);
            Loginresult loginresult = Loginresult.with().success(false).errormessage(this.sampleapp.displayText("lockedaccount", locale)).build();
            return loginresult;
        }
        catch (AuthenticationException e) {
            this.logger.warn("Login error: general authentication error", (Object)e);
            Loginresult loginresult = Loginresult.with().success(false).errormessage(this.sampleapp.displayText("unknownerror", locale)).build();
            return loginresult;
        }
        catch (Exception e) {
            this.logger.error("Login error: internal server error", (Object)e);
            throw new InternalServerErrorException();
        }
        finally {
            token.clear();
        }
    }

    @GET
    @Path(value="/logout")
    public Loginresult logout(@QueryParam(value="locale") String locale) {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return Loginresult.with().success(false).errormessage(this.sampleapp.displayText("loggedout", locale)).user(User.with().build()).build();
    }

    @GET
    @Path(value="/loginstate")
    public Loginresult loginstate(@QueryParam(value="locale") String locale) {
        Subject subject = SecurityUtils.getSubject();
        String username = (String)subject.getPrincipal();
        boolean success = subject.isAuthenticated();
        boolean harRoleSampleappuser = subject.hasRole("sampleappuser");
        String brukerLoggetInnMelding = harRoleSampleappuser ? this.sampleapp.displayText("userloggedinwithaccesses", locale) : this.sampleapp.displayText("userloggedinwithoutaccesses", locale);
        String melding = success ? brukerLoggetInnMelding : this.sampleapp.displayText("usernotloggedin", locale);
        User user = this.findUserSafely(username);
        return Loginresult.with().success(success).errormessage(melding).authorized(harRoleSampleappuser).user(user).build();
    }

    User findUserSafely(String username) {
        try {
            return this.useradmin.getUser(username);
        }
        catch (AuthserviceException e) {
            return User.with().build();
        }
    }
}

