/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sonar.collector.webhook;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class SonarBuild {
    static final String[] MEASUREMENT_FIELDS = new String[]{"lines", "bugs", "new_bugs", "vulnerabilities", "new_vulnerabilities", "code_smells", "new_code_smells", "coverage", "new_coverage"};
    private long analysedAt;
    private String project;
    private String version;
    private URL serverUrl;
    private Map<String, String> measurements;

    public SonarBuild(long analysedAt, String project, String version, URL serverUrl) {
        this.analysedAt = analysedAt;
        this.project = project;
        this.version = version;
        this.serverUrl = serverUrl;
        this.initializeMeasurements();
    }

    private void initializeMeasurements() {
        this.measurements = new HashMap<String, String>();
        for (String fieldName : MEASUREMENT_FIELDS) {
            this.measurements.put(fieldName, "0");
        }
    }

    public long getAnalysedAt() {
        return this.analysedAt;
    }

    public String getProject() {
        return this.project;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    public Map<String, String> getMeasurements() {
        return this.measurements;
    }
}

