/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sonar.collector.webhook;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.osgi.service.log.LogService;

public class SonarCollectorConfiguration {
    static final String SONARCOLLECTOR_JDBC_URL = "sonar.collector.jdbc.url";
    static final String SONARCOLLECTOR_JDBC_USER = "sonar.collector.jdbc.user";
    static final String SONARCOLLECTOR_JDBC_PASS = "sonar.collector.jdbc.password";
    static final String SONAR_MEASURES_COMPONENTS_METRIC_KEYS = "sonar.measures.components.metricKeys";
    private final Properties applicationProperties = new Properties();
    private Map<String, Object> injectedconfig = Collections.emptyMap();

    SonarCollectorConfiguration(LogService logservice) {
        try (InputStream propertiesFile = this.getApplicationProperties();){
            this.applicationProperties.load(propertiesFile);
        }
        catch (IOException e) {
            logservice.log(1, "SonarCollectorConfiguration failed to load the application.properties", (Throwable)e);
        }
    }

    protected InputStream getApplicationProperties() {
        return this.getClass().getClassLoader().getResourceAsStream("application.properties");
    }

    public void setConfig(Map<String, Object> config) {
        this.injectedconfig = config != null ? config : Collections.emptyMap();
    }

    public Properties getJdbcConnectionProperties() {
        Properties properties = new Properties();
        this.setJdbcUrlIfNotNull(properties);
        this.setPropertyIfNotNull(properties, "user", SONARCOLLECTOR_JDBC_USER);
        this.setPropertyIfNotNull(properties, "password", SONARCOLLECTOR_JDBC_PASS);
        return properties;
    }

    public String[] getMetricKeys() {
        Object metricKeysFromKarafConfig = this.injectedconfig.get(SONAR_MEASURES_COMPONENTS_METRIC_KEYS);
        if (metricKeysFromKarafConfig != null) {
            return ((String)metricKeysFromKarafConfig).split(",");
        }
        return System.getProperty(SONAR_MEASURES_COMPONENTS_METRIC_KEYS, this.applicationProperties.getProperty(SONAR_MEASURES_COMPONENTS_METRIC_KEYS)).split(",");
    }

    public String getJdbcUrl() {
        Object jdbcUrlFromKarafConfig = this.injectedconfig.get(SONARCOLLECTOR_JDBC_URL);
        if (jdbcUrlFromKarafConfig != null) {
            return (String)jdbcUrlFromKarafConfig;
        }
        return System.getProperty(SONARCOLLECTOR_JDBC_URL, this.applicationProperties.getProperty(SONARCOLLECTOR_JDBC_URL));
    }

    private void setJdbcUrlIfNotNull(Properties properties) {
        String jdbcUrl = this.getJdbcUrl();
        if (jdbcUrl != null) {
            properties.setProperty("url", jdbcUrl);
        }
    }

    private void setPropertyIfNotNull(Properties properties, String targetPropertyName, String sourcePropertyName) {
        Object valueFromKarafConfig = this.injectedconfig.get(sourcePropertyName);
        if (valueFromKarafConfig != null) {
            properties.setProperty(targetPropertyName, (String)valueFromKarafConfig);
            return;
        }
        String value = System.getProperty(sourcePropertyName, this.applicationProperties.getProperty(sourcePropertyName));
        if (value != null) {
            properties.setProperty(targetPropertyName, value);
        }
    }
}

