/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.sonar.collector.webhook;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import no.priv.bang.osgi.service.adapters.jdbc.DataSourceAdapter;
import no.priv.bang.osgi.service.adapters.jdbc.DataSourceFactoryAdapter;
import no.priv.bang.osgi.service.adapters.logservice.LogServiceAdapter;
import no.priv.bang.sonar.collector.webhook.NullDataSource;
import no.priv.bang.sonar.collector.webhook.SonarBuild;
import no.priv.bang.sonar.collector.webhook.SonarCollectorConfiguration;
import no.priv.bang.sonar.collector.webhook.URLConnectionFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.log.LogService;

@Component(service={Servlet.class}, property={"alias=/sonar-collector", "configurationPid=no.priv.bang.sonar.sonar-collector-webhook"})
public class SonarCollectorServlet
extends HttpServlet {
    private static final long serialVersionUID = -8421243385012454373L;
    static final DateTimeFormatter isoZonedDateTimeformatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HH:MM", "+00:00").optionalEnd().optionalStart().appendOffset("+HHMM", "+0000").optionalEnd().optionalStart().appendOffset("+HH", "Z").optionalEnd().toFormatter();
    private final Properties applicationProperties = new Properties();
    private final URLConnectionFactory factory;
    static final ObjectMapper mapper = new ObjectMapper();
    final DataSourceAdapter dataSource = new DataSourceAdapter();
    private final DataSourceFactoryAdapter dataSourceFactory = new DataSourceFactoryAdapter();
    private final LogServiceAdapter logservice = new LogServiceAdapter();
    private final SonarCollectorConfiguration configuration = new SonarCollectorConfiguration((LogService)this.logservice);

    @Reference
    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory.setFactory(dataSourceFactory);
    }

    @Reference
    public void setLogservice(LogService logservice) {
        this.logservice.setLogService(logservice);
    }

    @Activate
    public void activate(Map<String, Object> config) {
        this.configuration.setConfig(config);
        DataSource db = this.connectDataSource((DataSourceFactory)this.dataSourceFactory);
        this.createSchemaWithLiquibase(db);
        this.dataSource.setDatasource(db);
    }

    private DataSource connectDataSource(DataSourceFactory dataSourceFactory) {
        Properties properties = this.configuration.getJdbcConnectionProperties();
        try {
            return dataSourceFactory.createDataSource(properties);
        }
        catch (SQLException e) {
            this.logservice.log(1, "Sonar Collector servlet unable to connect to the database", (Throwable)e);
            return NullDataSource.getInstance();
        }
    }

    private void createSchemaWithLiquibase(DataSource db) {
        try (Connection connection = db.getConnection();){
            JdbcConnection databaseConnection = new JdbcConnection(connection);
            ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(((Object)((Object)this)).getClass().getClassLoader());
            Liquibase liquibase = new Liquibase("db-changelog/db-changelog-1.0.0.xml", (ResourceAccessor)classLoaderResourceAccessor, (DatabaseConnection)databaseConnection);
            liquibase.clearCheckSums();
            liquibase.update("");
        }
        catch (Exception e) {
            this.logservice.log(1, "Sonar Collector servlet unable to create or update the database schema", (Throwable)e);
        }
    }

    public SonarCollectorServlet(URLConnectionFactory factory) throws IOException {
        this.factory = factory;
        this.applicationProperties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("application.properties"));
    }

    public SonarCollectorServlet() throws IOException {
        this(new URLConnectionFactory(){

            @Override
            public HttpURLConnection openConnection(URL url) throws IOException {
                return (HttpURLConnection)url.openConnection();
            }
        });
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            SonarBuild build = this.callbackToSonarServerToGetMetrics((ServletRequest)request);
            this.saveMeasuresInDatabase(build);
        }
        catch (Exception e) {
            this.logservice.log(1, "Sonar Collector caught exception ", (Throwable)e);
            response.setStatus(500);
        }
    }

    SonarBuild callbackToSonarServerToGetMetrics(ServletRequest request) throws IOException {
        try (ServletInputStream postbody = request.getInputStream();){
            JsonNode root = mapper.readTree((InputStream)postbody);
            long analysedAt = this.parseTimestamp(root.path("analysedAt").asText());
            String project = root.path("project").path("key").asText();
            URL serverUrl = new URL(root.path("serverUrl").asText());
            URL componentsShowUrl = this.createSonarComponentsShowUrl(serverUrl, project);
            HttpURLConnection componentsShowUrlConnection = this.openConnection(componentsShowUrl);
            JsonNode componentsShowRoot = mapper.readTree(componentsShowUrlConnection.getInputStream());
            String version = componentsShowRoot.path("component").path("version").asText();
            SonarBuild build = new SonarBuild(analysedAt, project, version, serverUrl);
            this.logWarningIfVersionIsMissing(build, componentsShowUrl);
            URL measurementsUrl = this.createSonarMeasurementsComponentUrl(build, this.configuration.getMetricKeys());
            HttpURLConnection measurementsUrlConnection = this.openConnection(measurementsUrl);
            JsonNode measurementsRoot = mapper.readTree(measurementsUrlConnection.getInputStream());
            this.parseMeasures(build.getMeasurements(), measurementsRoot.path("component").path("measures"));
            SonarBuild sonarBuild = build;
            return sonarBuild;
        }
    }

    long parseTimestamp(String timestamp) {
        return ZonedDateTime.parse(timestamp, isoZonedDateTimeformatter).toEpochSecond() * 1000L;
    }

    private void logWarningIfVersionIsMissing(SonarBuild build, URL componentsShowUrl) {
        if ("".equals(build.getVersion())) {
            this.logservice.log(2, String.format("Maven version is missing from build \"%s\". API URL used to request the version, is: %s", build.getProject(), componentsShowUrl.toString()));
        }
    }

    /*
     * Exception decompiling
     */
    private int saveMeasuresInDatabase(SonarBuild build) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean versionIsReleaseVersion(String version) {
        return !"".equals(version) && !version.endsWith("-SNAPSHOT");
    }

    public Map<String, String> parseMeasures(Map<String, String> measuresResults, JsonNode measuresNode) {
        for (JsonNode measureNode : measuresNode) {
            String metric = measureNode.path("metric").asText();
            String value = measureNode.path("value").asText();
            if ("".equals(value)) {
                value = measureNode.path("periods").path(0).path("value").asText();
            }
            measuresResults.put(metric, value);
        }
        return measuresResults;
    }

    public URL createSonarComponentsShowUrl(URL serverUrl, String project) throws IOException {
        String localPath = String.format("/api/components/show?component=%s", URLEncoder.encode(project, "UTF-8"));
        return new URL(serverUrl, localPath);
    }

    public URL createSonarMeasurementsComponentUrl(SonarBuild build, String[] metricKeys) throws IOException {
        String localPath = String.format("/api/measures/component?componentKey=%s&metricKeys=%s", URLEncoder.encode(build.getProject(), "UTF-8"), String.join((CharSequence)",", metricKeys));
        return new URL(build.getServerUrl(), localPath);
    }

    HttpURLConnection openConnection(URL url) throws IOException {
        return this.factory.openConnection(url);
    }

    public SonarCollectorConfiguration getConfiguration() {
        return this.configuration;
    }
}

