/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.backend.users;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import no.priv.bang.osgiservice.users.Permission;
import no.priv.bang.osgiservice.users.Role;
import no.priv.bang.osgiservice.users.RolePermissions;
import no.priv.bang.osgiservice.users.User;
import no.priv.bang.osgiservice.users.UserAndPasswords;
import no.priv.bang.osgiservice.users.UserManagementService;
import no.priv.bang.osgiservice.users.UserRoles;
import no.priv.bang.ukelonn.UkelonnBadRequestException;
import no.priv.bang.ukelonn.UkelonnDatabase;
import no.priv.bang.ukelonn.UkelonnException;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.util.ByteSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;

@Component(service={UserManagementService.class}, immediate=true)
public class UserManagementServiceProvider
implements UserManagementService {
    private static final String METHOD_NOT_IMPLMENENTED_MESSAGE = "Method not implmenented";
    private LogService logservice;
    private UkelonnDatabase database;

    @Reference
    public void setLogService(LogService logservice) {
        this.logservice = logservice;
    }

    @Reference
    public void setDatabase(UkelonnDatabase database) {
        this.database = database;
    }

    @Activate
    public void activate() {
    }

    public List<User> getUsers() {
        ArrayList<User> users = new ArrayList<User>();
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement("select * from users order by user_id");
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                User user = this.getUserFromResultset(resultSet);
                users.add(user);
            }
        }
        catch (SQLException e) {
            throw new UkelonnException("Failed to get the list of users", (Throwable)e);
        }
        return users;
    }

    private User getUserFromResultset(ResultSet results) throws SQLException {
        int id = results.getInt(1);
        String username = results.getString(2);
        String email = results.getString(5);
        String firstname = results.getString(6);
        String lastname = results.getString(7);
        return new User(id, username, email, firstname, lastname);
    }

    public List<User> modifyUser(User user) {
        try (Connection connection = this.database.getConnection();
             PreparedStatement updateUserSql = connection.prepareStatement("update users set username=?, email=?, first_name=?, last_name=? where user_id=?");){
            updateUserSql.setString(1, user.getUsername());
            updateUserSql.setString(2, user.getEmail());
            updateUserSql.setString(3, user.getFirstname());
            updateUserSql.setString(4, user.getLastname());
            updateUserSql.setInt(5, user.getUserid());
            updateUserSql.executeUpdate();
        }
        catch (SQLException e) {
            throw new UkelonnException(String.format("Failed to update user %d in the database", user.getUserid()), (Throwable)e);
        }
        return this.getUsers();
    }

    public List<User> updatePassword(UserAndPasswords userAndPasswords) {
        if (!UserManagementServiceProvider.hasUserWithNonEmptyUsername(userAndPasswords)) {
            String message = "Empty username when changing password";
            this.logservice.log(2, String.format("Bad request: %s", message));
            throw new UkelonnBadRequestException(message);
        }
        if (!UserManagementServiceProvider.passwordsEqualsAndNotEmpty(userAndPasswords)) {
            String message = String.format("Passwords don't match and/or are empty when changing passwords for user \"%s\"", userAndPasswords.getUser().getUsername());
            this.logservice.log(2, String.format("Bad request: %s", message));
            throw new UkelonnBadRequestException(message);
        }
        String username = userAndPasswords.getUser().getUsername();
        String password = userAndPasswords.getPassword1();
        String salt = UserManagementServiceProvider.getNewSalt();
        String hashedPassword = UserManagementServiceProvider.hashPassword(password, salt);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement("update users set password=?, salt=? where username=?");){
            statement.setString(1, hashedPassword);
            statement.setString(2, salt);
            statement.setString(3, username);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            String message = String.format("Database failure when changing password for user \"%s\"", userAndPasswords.getUser().getUsername());
            this.logservice.log(1, message);
            throw new UkelonnException(message);
        }
        return this.getUsers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<User> addUser(UserAndPasswords passwords) {
        if (!UserManagementServiceProvider.passwordsEqualsAndNotEmpty(passwords)) {
            throw new UkelonnBadRequestException("Passwords are not identical and/or empty");
        }
        String newUserUsername = passwords.getUser().getUsername();
        String newUserPassword = passwords.getPassword1();
        String newUserEmail = passwords.getUser().getEmail();
        String newUserFirstname = passwords.getUser().getFirstname();
        String newUserLastname = passwords.getUser().getLastname();
        String salt = UserManagementServiceProvider.getNewSalt();
        String hashedPassword = UserManagementServiceProvider.hashPassword(newUserPassword, salt);
        try (Connection connection = this.database.getConnection();){
            try (PreparedStatement insertUserSql = connection.prepareStatement("insert into users (username, password, salt, email, first_name, last_name) values (?, ?, ?, ?, ?, ?)");){
                insertUserSql.setString(1, newUserUsername);
                insertUserSql.setString(2, hashedPassword);
                insertUserSql.setString(3, salt);
                insertUserSql.setString(4, newUserEmail);
                insertUserSql.setString(5, newUserFirstname);
                insertUserSql.setString(6, newUserLastname);
                insertUserSql.executeUpdate();
            }
            List<User> list = this.getUsers();
            return list;
        }
        catch (SQLException e) {
            String message = "Database exception when creating user";
            this.logservice.log(1, message, (Throwable)e);
            throw new UkelonnException(message, (Throwable)e);
        }
    }

    public List<Role> getRoles() {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public List<Role> modifyRole(Role role) {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public List<Role> addRole(Role newRole) {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public List<Permission> getPermissions() {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public List<Permission> modifyPermission(Permission permission) {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public List<Permission> addPermission(Permission newPermission) {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public Map<String, List<Role>> getUserRoles() {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public Map<String, List<Role>> addUserRoles(UserRoles userroles) {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public Map<String, List<Role>> removeUserRoles(UserRoles userroles) {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public Map<String, List<Permission>> getRolesPermissions() {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public Map<String, List<Permission>> addRolePermissions(RolePermissions rolepermissions) {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    public Map<String, List<Permission>> removeRolePermissions(RolePermissions rolepermissions) {
        throw new UnsupportedOperationException(METHOD_NOT_IMPLMENENTED_MESSAGE);
    }

    static String getNewSalt() {
        SecureRandomNumberGenerator randomNumberGenerator = new SecureRandomNumberGenerator();
        return randomNumberGenerator.nextBytes().toBase64();
    }

    static String hashPassword(String newUserPassword, String salt) {
        ByteSource decodedSaltUsedWhenHashing = ByteSource.Util.bytes((byte[])Base64.getDecoder().decode(salt));
        return new Sha256Hash((Object)newUserPassword, (Object)decodedSaltUsedWhenHashing, 1024).toBase64();
    }

    static boolean passwordsEqualsAndNotEmpty(UserAndPasswords passwords) {
        if (passwords.getPassword1() == null || passwords.getPassword1().isEmpty()) {
            return false;
        }
        return passwords.getPassword1().equals(passwords.getPassword2());
    }

    static boolean hasUserWithNonEmptyUsername(UserAndPasswords passwords) {
        User user = passwords.getUser();
        if (user == null) {
            return false;
        }
        String username = user.getUsername();
        if (username == null) {
            return false;
        }
        return !username.isEmpty();
    }
}

