/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.backend;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sql.DataSource;
import no.priv.bang.authservice.definitions.AuthserviceException;
import no.priv.bang.osgiservice.users.Role;
import no.priv.bang.osgiservice.users.User;
import no.priv.bang.osgiservice.users.UserManagementService;
import no.priv.bang.osgiservice.users.UserRoles;
import no.priv.bang.ukelonn.UkelonnException;
import no.priv.bang.ukelonn.UkelonnService;
import no.priv.bang.ukelonn.backend.UkelonnServiceBase;
import no.priv.bang.ukelonn.beans.Account;
import no.priv.bang.ukelonn.beans.Bonus;
import no.priv.bang.ukelonn.beans.LocaleBean;
import no.priv.bang.ukelonn.beans.Notification;
import no.priv.bang.ukelonn.beans.PasswordsWithUser;
import no.priv.bang.ukelonn.beans.PerformedTransaction;
import no.priv.bang.ukelonn.beans.SumYear;
import no.priv.bang.ukelonn.beans.SumYearMonth;
import no.priv.bang.ukelonn.beans.Transaction;
import no.priv.bang.ukelonn.beans.TransactionType;
import no.priv.bang.ukelonn.beans.UpdatedTransaction;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Component(service={UkelonnService.class}, immediate=true, property={"defaultlocale=nb_NO"})
public class UkelonnServiceProvider
extends UkelonnServiceBase {
    private static final String RESOURCES_BASENAME = "i18n.ApplicationResources";
    private DataSource datasource;
    private UserManagementService useradmin;
    private LogService logservice;
    private Logger logger;
    private ConcurrentHashMap<String, ConcurrentLinkedQueue<Notification>> notificationQueues = new ConcurrentHashMap();
    private Locale defaultLocale;
    static final String LAST_NAME = "last_name";
    static final String FIRST_NAME = "first_name";
    static final String USERNAME = "username";
    static final String USER_ID = "user_id";

    @Activate
    public void activate(Map<String, Object> config) {
        this.defaultLocale = Locale.forLanguageTag(((String)config.get("defaultlocale")).replace('_', '-'));
        this.addRolesIfNotPresent();
    }

    @Reference(target="(osgi.jndi.service.name=jdbc/ukelonn)")
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Override
    public DataSource getDataSource() {
        return this.datasource;
    }

    @Reference
    public void setUserAdmin(UserManagementService useradmin) {
        this.useradmin = useradmin;
    }

    @Reference
    public void setLogservice(LogService logservice) {
        this.logservice = logservice;
        this.logger = logservice.getLogger(this.getClass());
    }

    @Override
    public LogService getLogservice() {
        return this.logservice;
    }

    public List<Account> getAccounts() {
        ArrayList<Account> accounts = new ArrayList<Account>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select account_id, username, balance from accounts_view");
             ResultSet results = statement.executeQuery();){
            if (results != null) {
                while (results.next()) {
                    Account newaccount = this.mapAccount(results);
                    accounts.add(newaccount);
                }
            }
        }
        catch (SQLException e) {
            this.logError("Error when getting all accounts from the database", e);
        }
        return accounts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Account getAccount(String username) {
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select account_id, username, balance from accounts_view where username=?");){
            statement.setString(1, username);
            try (ResultSet resultset = statement.executeQuery();){
                if (resultset.next()) {
                    Account account = this.mapAccount(resultset);
                    return account;
                }
                throw new UkelonnException(String.format("Got an empty ResultSet while fetching account from the database for user \\\"%s\\\"", username));
            }
        }
        catch (SQLException e) {
            throw new UkelonnException(String.format("Caught SQLException while fetching account from the database for user \"%s\"", username), (Throwable)e);
        }
    }

    public Account registerPerformedJob(PerformedTransaction job) {
        int accountId = job.account().accountId();
        int jobtypeId = job.transactionTypeId();
        double jobamount = this.addBonus(job.transactionAmount());
        Date timeofjob = job.transactionDate();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("insert into transactions (account_id, transaction_type_id,transaction_amount, transaction_time) values (?, ?, ?, ?)");){
            statement.setInt(1, accountId);
            statement.setInt(2, jobtypeId);
            statement.setDouble(3, jobamount);
            statement.setTimestamp(4, new Timestamp(timeofjob.getTime()));
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            String message = String.format("Failed to register performed job in the database, account: %d  jobtype: %d  amount: %f", accountId, jobtypeId, jobamount);
            this.logError(message, exception);
        }
        return this.getAccount(job.account().username());
    }

    public List<TransactionType> getJobTypes() {
        ArrayList<TransactionType> jobtypes = new ArrayList<TransactionType>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select transaction_type_id, transaction_type_name, transaction_amount, transaction_is_work, transaction_is_wage_payment from transaction_types where transaction_is_work=true");
             ResultSet resultSet = statement.executeQuery();){
            if (resultSet != null) {
                while (resultSet.next()) {
                    TransactionType transactiontype = UkelonnServiceProvider.mapTransactionType(resultSet);
                    jobtypes.add(transactiontype);
                }
            }
        }
        catch (SQLException e) {
            this.logError("Error getting job types from the database", e);
        }
        return jobtypes;
    }

    public List<Transaction> getJobs(int accountId, int pageNumber, int pageSize) {
        return this.getTransactionsFromAccount(accountId, "/sql/query/jobs_last_n.sql", "job", pageNumber, pageSize);
    }

    public List<Transaction> getPayments(int accountId, int pageNumber, int pageSize) {
        List<Transaction> payments = this.getTransactionsFromAccount(accountId, "/sql/query/payments_last_n.sql", "payments", pageNumber, pageSize);
        payments = UkelonnServiceProvider.makePaymentAmountsPositive(payments);
        return payments;
    }

    List<Transaction> getTransactionsFromAccount(int accountId, String sqlTemplate, String transactionType, int pageNumber, int pageSize) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        String sql = String.format(this.getResourceAsString(sqlTemplate), pageNumber * pageSize, pageSize);
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, accountId);
            UkelonnServiceProvider.trySettingPreparedStatementParameterThatMayNotBePresent(statement, 2, accountId);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    transactions.add(UkelonnServiceProvider.mapTransaction(resultSet));
                }
            }
        }
        catch (SQLException e) {
            this.logError("Error getting " + transactionType + "s from the database", e);
        }
        return transactions;
    }

    public List<Transaction> deleteJobsFromAccount(int accountId, List<Integer> idsOfJobsToDelete) {
        if (!idsOfJobsToDelete.isEmpty()) {
            String deleteQuery = "delete from transactions where transaction_id in (select transaction_id from transactions inner join transaction_types on transactions.transaction_type_id=transaction_types.transaction_type_id where transaction_id in (" + String.valueOf(UkelonnServiceProvider.joinIds(idsOfJobsToDelete)) + ") and transaction_types.transaction_is_work=? and account_id=?)";
            try (Connection connection = this.datasource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(deleteQuery);){
                this.addParametersToDeleteJobsStatement(accountId, statement);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                String message = String.format("Failed to delete jobs from accountId: %d", accountId);
                this.logError(message, e);
            }
        }
        return this.getJobs(accountId, 0, 10);
    }

    void addParametersToDeleteJobsStatement(int accountId, PreparedStatement statement) {
        try {
            statement.setBoolean(1, true);
            statement.setInt(2, accountId);
        }
        catch (SQLException e) {
            String message = "Caught exception adding parameters to job delete statement";
            this.logger.error(message, (Object)e);
            throw new UkelonnException(message, (Throwable)e);
        }
    }

    public List<Transaction> updateJob(UpdatedTransaction editedJob) {
        String sql = "update transactions set transaction_type_id=?, transaction_time=?, transaction_amount=? where transaction_id=?";
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, editedJob.transactionTypeId());
            statement.setTimestamp(2, new Timestamp(editedJob.transactionTime().getTime()));
            statement.setDouble(3, editedJob.transactionAmount());
            statement.setInt(4, editedJob.id());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new UkelonnException(String.format("Failed to update job with id %d", editedJob.id()), (Throwable)e);
        }
        return this.getJobs(editedJob.accountId(), 0, 10);
    }

    public List<TransactionType> getPaymenttypes() {
        ArrayList<TransactionType> paymenttypes = new ArrayList<TransactionType>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select transaction_type_id, transaction_type_name, transaction_amount, transaction_is_work, transaction_is_wage_payment from transaction_types where transaction_is_wage_payment=true");
             ResultSet resultSet = statement.executeQuery();){
            if (resultSet != null) {
                while (resultSet.next()) {
                    TransactionType transactiontype = UkelonnServiceProvider.mapTransactionType(resultSet);
                    paymenttypes.add(transactiontype);
                }
            }
        }
        catch (SQLException e) {
            this.logError("Error getting payment types from the database", e);
        }
        return paymenttypes;
    }

    public Account registerPayment(PerformedTransaction payment) {
        int accountId = payment.account().accountId();
        int transactionTypeId = payment.transactionTypeId();
        double amount = 0.0 - payment.transactionAmount();
        Date transactionDate = new Date();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("insert into transactions (account_id,transaction_type_id,transaction_amount, transaction_time) values (?, ?, ?, ?)");){
            statement.setInt(1, accountId);
            statement.setInt(2, transactionTypeId);
            statement.setDouble(3, amount);
            statement.setTimestamp(4, new Timestamp(transactionDate.getTime()));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            String message = String.format("Failed to register payment  accountId: %d  transactionTypeId: %d  amount: %f", accountId, transactionTypeId, amount);
            this.logError(message, e);
            return null;
        }
        return this.getAccount(payment.account().username());
    }

    public List<TransactionType> modifyJobtype(TransactionType jobtype) {
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("update transaction_types set transaction_type_name=?, transaction_amount=?, transaction_is_work=true, transaction_is_wage_payment=false where transaction_type_id=?");){
            statement.setString(1, jobtype.transactionTypeName());
            statement.setDouble(2, jobtype.transactionAmount());
            statement.setInt(3, jobtype.id());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            String message = String.format("Failed to update jobtype %d in the database", jobtype.id());
            this.logError(message, e);
            throw new UkelonnException(message, (Throwable)e);
        }
        return this.getJobTypes();
    }

    public List<TransactionType> createJobtype(TransactionType jobtype) {
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("insert into transaction_types (transaction_type_name, transaction_amount, transaction_is_work, transaction_is_wage_payment) values (?, ?, true, false)");){
            statement.setString(1, jobtype.transactionTypeName());
            statement.setObject(2, jobtype.transactionAmount());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            String message = String.format("Failed to create jobtype \"%s\" in the database", jobtype.transactionTypeName());
            this.logError(message, e);
            throw new UkelonnException(message, (Throwable)e);
        }
        return this.getJobTypes();
    }

    public List<TransactionType> modifyPaymenttype(TransactionType paymenttype) {
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("update transaction_types set transaction_type_name=?, transaction_amount=?, transaction_is_work=false, transaction_is_wage_payment=true where transaction_type_id=?");){
            statement.setString(1, paymenttype.transactionTypeName());
            statement.setDouble(2, paymenttype.transactionAmount());
            statement.setInt(3, paymenttype.id());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            String message = String.format("Failed to update payment type %d in the database", paymenttype.id());
            this.logError(message, e);
            throw new UkelonnException(message, (Throwable)e);
        }
        return this.getPaymenttypes();
    }

    public List<TransactionType> createPaymenttype(TransactionType paymenttype) {
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("insert into transaction_types (transaction_type_name, transaction_amount, transaction_is_work, transaction_is_wage_payment) values (?, ?, false, true)");){
            statement.setString(1, paymenttype.transactionTypeName());
            statement.setObject(2, paymenttype.transactionAmount());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            String message = String.format("Failed to create payment type \"%s\" in the database", paymenttype.transactionTypeName());
            this.logError(message, e);
            throw new UkelonnException(message, (Throwable)e);
        }
        return this.getPaymenttypes();
    }

    public Account addAccount(no.priv.bang.ukelonn.beans.User user) {
        PreparedStatement insertAccountSql2;
        block15: {
            String username = user.username();
            Connection connection = this.datasource.getConnection();
            try {
                insertAccountSql2 = connection.prepareStatement("insert into accounts (username) values (?)");
                try {
                    insertAccountSql2.setString(1, username);
                    insertAccountSql2.executeUpdate();
                }
                finally {
                    if (insertAccountSql2 != null) {
                        insertAccountSql2.close();
                    }
                }
                this.addDummyPaymentToAccountSoThatAccountWillAppearInAccountsView(username);
                insertAccountSql2 = this.getAccount(user.username());
                if (connection == null) break block15;
            }
            catch (Throwable insertAccountSql2) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            insertAccountSql2.addSuppressed(throwable);
                        }
                    }
                    throw insertAccountSql2;
                }
                catch (SQLException e) {
                    String message = "Database exception when account for new user";
                    this.logger.error(message, (Object)e);
                    throw new UkelonnException(message, (Throwable)e);
                }
            }
            connection.close();
        }
        return insertAccountSql2;
    }

    public List<SumYear> earningsSumOverYear(String username) {
        ArrayList<SumYear> statistics = new ArrayList<SumYear>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select aggregate_amount, aggregate_year from sum_over_year_view where username=?");){
            statement.setString(1, username);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    SumYear sumYear = SumYear.with().sum(resultSet.getDouble(1)).year(resultSet.getInt(2)).build();
                    statistics.add(sumYear);
                }
            }
        }
        catch (SQLException e) {
            this.logWarning(String.format("Failed to get sum of earnings per year for account \"%s\" from the database", username), e);
        }
        return statistics;
    }

    public List<SumYearMonth> earningsSumOverMonth(String username) {
        ArrayList<SumYearMonth> statistics = new ArrayList<SumYearMonth>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select aggregate_amount, aggregate_year, aggregate_month from sum_over_year_and_month_view where username=?");){
            statement.setString(1, username);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    SumYearMonth sumYearMonth = SumYearMonth.with().sum(resultSet.getDouble(1)).year(resultSet.getInt(2)).month(resultSet.getInt(3)).build();
                    statistics.add(sumYearMonth);
                }
            }
        }
        catch (SQLException e) {
            this.logWarning(String.format("Failed to get sum of earnings per month for account \"%s\" from the database", username), e);
        }
        return statistics;
    }

    public List<Notification> notificationsTo(String username) {
        ConcurrentLinkedQueue<Notification> notifications = this.getNotificationQueueForUser(username);
        Notification notification = notifications.poll();
        if (notification == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(notification);
    }

    public void notificationTo(String username, Notification notification) {
        ConcurrentLinkedQueue<Notification> notifications = this.getNotificationQueueForUser(username);
        notifications.add(notification);
    }

    public List<Bonus> getActiveBonuses() {
        ArrayList<Bonus> activebonuses = new ArrayList<Bonus>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select bonus_id, enabled, iconurl, title, description, bonus_factor, start_date, end_date from bonuses where enabled and start_date <= ? and end_date >= ?");){
            Timestamp today = Timestamp.from(new Date().toInstant());
            statement.setTimestamp(1, today);
            statement.setTimestamp(2, today);
            try (ResultSet results = statement.executeQuery();){
                while (results.next()) {
                    this.buildBonusFromResultSetAndAddToList(activebonuses, results);
                }
            }
        }
        catch (SQLException e) {
            this.logWarning("Failed to get list of active bonuses", e);
        }
        return activebonuses;
    }

    public List<Bonus> getAllBonuses() {
        ArrayList<Bonus> allbonuses = new ArrayList<Bonus>();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select bonus_id, enabled, iconurl, title, description, bonus_factor, start_date, end_date from bonuses");
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                this.buildBonusFromResultSetAndAddToList(allbonuses, results);
            }
        }
        catch (SQLException e) {
            this.logWarning("Failed to get list of all bonuses", e);
        }
        return allbonuses;
    }

    public List<Bonus> createBonus(Bonus newBonus) {
        String title = newBonus.title();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("insert into bonuses (enabled, iconurl, title, description, bonus_factor, start_date, end_date) values (?, ?, ?, ?, ?, ?, ?)");){
            statement.setBoolean(1, newBonus.enabled());
            statement.setString(2, newBonus.iconurl());
            statement.setString(3, title);
            statement.setString(4, newBonus.description());
            statement.setDouble(5, newBonus.bonusFactor());
            Date startDate = newBonus.startDate() != null ? newBonus.startDate() : new Date();
            statement.setTimestamp(6, Timestamp.from(startDate.toInstant()));
            Date endDate = newBonus.endDate() != null ? newBonus.endDate() : new Date();
            statement.setTimestamp(7, Timestamp.from(endDate.toInstant()));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.logWarning(String.format("Failed to add Bonus with title \"%s\"", title), e);
        }
        return this.getAllBonuses();
    }

    public List<Bonus> modifyBonus(Bonus updatedBonus) {
        int id = updatedBonus.bonusId();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("update bonuses set enabled=?, iconurl=?, title=?, description=?, bonus_factor=?, start_date=?, end_date=? where bonus_id=?");){
            statement.setBoolean(1, updatedBonus.enabled());
            statement.setString(2, updatedBonus.iconurl());
            statement.setString(3, updatedBonus.title());
            statement.setString(4, updatedBonus.description());
            statement.setDouble(5, updatedBonus.bonusFactor());
            statement.setTimestamp(6, Timestamp.from(updatedBonus.startDate().toInstant()));
            statement.setTimestamp(7, Timestamp.from(updatedBonus.endDate().toInstant()));
            statement.setInt(8, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.logWarning(String.format("Failed to update Bonus with database id %d", id), e);
        }
        return this.getAllBonuses();
    }

    public List<Bonus> deleteBonus(Bonus removedBonus) {
        int id = removedBonus.bonusId();
        try (Connection connection = this.datasource.getConnection();
             PreparedStatement statement = connection.prepareStatement("delete from bonuses where bonus_id=?");){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.logWarning(String.format("Failed to delete Bonus with database id %d", id), e);
        }
        return this.getAllBonuses();
    }

    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    public List<LocaleBean> availableLocales() {
        return Arrays.asList(Locale.forLanguageTag("nb-NO"), Locale.UK).stream().map(l -> LocaleBean.with().locale(l).build()).toList();
    }

    public Map<String, String> displayTexts(Locale locale) {
        return this.transformResourceBundleToMap(locale);
    }

    private ConcurrentLinkedQueue<Notification> getNotificationQueueForUser(String username) {
        return this.notificationQueues.computeIfAbsent(username, k -> new ConcurrentLinkedQueue());
    }

    double addBonus(double transactionAmount) {
        List<Bonus> activebonuses = this.getActiveBonuses();
        if (activebonuses.isEmpty()) {
            return transactionAmount;
        }
        double bonus = activebonuses.stream().mapToDouble(b -> b.bonusFactor() * transactionAmount - transactionAmount).sum();
        return transactionAmount + bonus;
    }

    void buildBonusFromResultSetAndAddToList(List<Bonus> allbonuses, ResultSet results) throws SQLException {
        Bonus bonus = Bonus.with().bonusId(results.getInt("bonus_id")).enabled(results.getBoolean("enabled")).iconurl(results.getString("iconurl")).title(results.getString("title")).description(results.getString("description")).bonusFactor(results.getDouble("bonus_factor")).startDate(Date.from(results.getTimestamp("start_date").toInstant())).endDate(Date.from(results.getTimestamp("end_date").toInstant())).build();
        allbonuses.add(bonus);
    }

    static boolean passwordsEqualsAndNotEmpty(PasswordsWithUser passwords) {
        if (passwords.password() == null || passwords.password().isEmpty()) {
            return false;
        }
        return passwords.password().equals(passwords.password2());
    }

    static StringBuilder joinIds(List<Integer> ids) {
        StringBuilder commaList = new StringBuilder();
        if (ids == null) {
            return commaList;
        }
        Iterator<Integer> iterator = ids.iterator();
        if (!iterator.hasNext()) {
            return commaList;
        }
        commaList.append(iterator.next());
        while (iterator.hasNext()) {
            commaList.append(", ").append(iterator.next());
        }
        return commaList;
    }

    static boolean hasUserWithNonEmptyUsername(PasswordsWithUser passwords) {
        no.priv.bang.ukelonn.beans.User user = passwords.user();
        if (user == null) {
            return false;
        }
        String username = user.username();
        if (username == null) {
            return false;
        }
        return !username.isEmpty();
    }

    private static void trySettingPreparedStatementParameterThatMayNotBePresent(PreparedStatement statement, int parameterId, int parameterValue) {
        try {
            statement.setInt(parameterId, parameterValue);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void logError(String message, Exception e) {
        this.logger.error(message, (Object)e);
    }

    private void logWarning(String message, Exception e) {
        this.logger.warn(message, (Object)e);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    int addDummyPaymentToAccountSoThatAccountWillAppearInAccountsView(String username) {
        try (Connection connection = this.datasource.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement(this.getResourceAsString("/sql/query/insert_empty_payment_in_account_keyed_by_username.sql"));
                try {
                    statement.setString(1, username);
                    n = statement.executeUpdate();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.logError("Failed to set prepared statement argument", e);
            return -1;
        }
    }

    String getResourceAsString(String resourceName) {
        String string;
        block9: {
            ByteArrayOutputStream resource = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            InputStream resourceStream = this.getClass().getResourceAsStream(resourceName);
            try {
                int length;
                while ((length = resourceStream.read(buffer)) != -1) {
                    resource.write(buffer, 0, length);
                }
                string = resource.toString(StandardCharsets.UTF_8);
                if (resourceStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logError("Error getting resource \"" + String.valueOf(resource) + "\" from the classpath", e);
                    return null;
                }
            }
            resourceStream.close();
        }
        return string;
    }

    public Account mapAccount(ResultSet results) throws SQLException {
        String username = results.getString(USERNAME);
        try {
            User user = this.useradmin.getUser(username);
            return Account.with().accountid(results.getInt("account_id")).username(username).firstName(user.firstname()).lastName(user.lastname()).balance(results.getDouble("balance")).build();
        }
        catch (AuthserviceException e) {
            this.logWarning(String.format("No authservice user for username \"%s\" when fetching account", username), (Exception)((Object)e));
            return Account.with().accountid(results.getInt("account_id")).username(username).balance(results.getDouble("balance")).build();
        }
    }

    private void addRolesIfNotPresent() {
        Optional<Role> ukelonnadmin = this.addRoleIfNotPresent("ukelonnadmin", "Administrator av applikasjonen ukelonn");
        this.addRoleIfNotPresent("ukelonnuser", "Bruker av applikasjonen ukelonn");
        this.addAdminroleToUserAdmin(ukelonnadmin);
    }

    Optional<Role> addRoleIfNotPresent(String rolename, String description) {
        List roles = this.useradmin.getRoles();
        Optional<Role> existingRole = roles.stream().filter(r -> rolename.equals(r.rolename())).findFirst();
        if (!existingRole.isPresent()) {
            roles = this.useradmin.addRole(Role.with().rolename(rolename).description(description).build());
            return roles.stream().filter(r -> rolename.equals(r.rolename())).findFirst();
        }
        return existingRole;
    }

    void addAdminroleToUserAdmin(Optional<Role> ukelonnadmin) {
        if (ukelonnadmin.isPresent()) {
            try {
                User admin = this.useradmin.getUser("admin");
                List roles = this.useradmin.getRolesForUser("admin");
                if (roles.stream().noneMatch(r -> ((Role)ukelonnadmin.get()).equals(r))) {
                    this.useradmin.addUserRoles(UserRoles.with().user(admin).roles(Arrays.asList(ukelonnadmin.get())).build());
                }
            }
            catch (AuthserviceException authserviceException) {
                // empty catch block
            }
        }
    }

    static Transaction mapTransaction(ResultSet resultset) throws SQLException {
        return Transaction.with().id(resultset.getInt("transaction_id")).transactionType(UkelonnServiceProvider.mapTransactionType(resultset)).transactionTime((Date)resultset.getTimestamp("transaction_time")).transactionAmount(resultset.getDouble("transaction_amount")).paidOut(resultset.getBoolean("paid_out")).build();
    }

    static List<Transaction> makePaymentAmountsPositive(List<Transaction> payments) {
        ArrayList<Transaction> paymentsWithPositiveAmounts = new ArrayList<Transaction>(payments.size());
        for (Transaction payment : payments) {
            double amount = Math.abs(payment.transactionAmount());
            paymentsWithPositiveAmounts.add(Transaction.with((Transaction)payment).transactionAmount(amount).build());
        }
        return paymentsWithPositiveAmounts;
    }

    static TransactionType mapTransactionType(ResultSet resultset) throws SQLException {
        return TransactionType.with().id(resultset.getInt("transaction_type_id")).transactionTypeName(resultset.getString("transaction_type_name")).transactionAmount(Double.valueOf(resultset.getDouble("transaction_amount"))).transactionIsWork(resultset.getBoolean("transaction_is_work")).transactionIsWagePayment(resultset.getBoolean("transaction_is_wage_payment")).build();
    }

    Map<String, String> transformResourceBundleToMap(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCES_BASENAME, locale);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, bundle.getString(key));
        }
        return map;
    }
}

