/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.db.derbytest;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import no.priv.bang.osgiservice.database.DatabaseServiceBase;
import no.priv.bang.ukelonn.UkelonnDatabase;
import no.priv.bang.ukelonn.db.liquibase.UkelonnLiquibase;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.log.LogService;

@Component(service={UkelonnDatabase.class}, immediate=true)
public class UkelonnDatabaseProvider
extends DatabaseServiceBase
implements UkelonnDatabase {
    private LogService logService;
    private DataSourceFactory dataSourceFactory;
    private DataSource datasource;
    private boolean initialChangelog = false;

    @Reference
    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    @Reference(target="(osgi.jdbc.driver.name=derby)")
    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate() {
        this.createDatasource();
        UkelonnLiquibase liquibase = new UkelonnLiquibase();
        try (Connection connect = this.getConnection();){
            try {
                liquibase.createInitialSchema(connect);
                this.insertMockData();
                liquibase.updateSchema(connect);
            }
            finally {
                connect.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            this.logError("Failed to create derby test database schema", e);
        }
    }

    void createDatasource() {
        Properties properties = new Properties();
        properties.setProperty("url", "jdbc:derby:memory:ukelonn;create=true");
        try {
            this.datasource = this.dataSourceFactory.createDataSource(properties);
        }
        catch (Exception e) {
            this.logError("Derby mock database failed to create datasource", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RanChangeSet> getChangeLogHistory() throws DatabaseException, SQLException {
        Throwable throwable = null;
        try (Connection connect = this.getConnection();){
            List list;
            JdbcConnection databaseConnection = new JdbcConnection(connect);
            try {
                Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)databaseConnection);
                StandardChangeLogHistoryService logHistoryService = (StandardChangeLogHistoryService)ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
                list = logHistoryService.getRanChangeSets();
            }
            catch (Throwable throwable2) {
                try {
                    databaseConnection.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            databaseConnection.close();
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean insertMockData() {
        try (Connection connect = this.getConnection();){
            Liquibase liquibase;
            JdbcConnection databaseConnection = new JdbcConnection(connect);
            ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(((Object)((Object)this)).getClass().getClassLoader());
            if (this.hasTable(connect, "user_roles")) {
                this.initialChangelog = false;
                liquibase = new Liquibase("sql/data/db-changelog.xml", (ResourceAccessor)classLoaderResourceAccessor, (DatabaseConnection)databaseConnection);
                liquibase.update("");
            } else {
                this.initialChangelog = true;
                liquibase = new Liquibase("sql/data/db-initial-changelog.xml", (ResourceAccessor)classLoaderResourceAccessor, (DatabaseConnection)databaseConnection);
                liquibase.update("");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logError("Failed to fill derby test database with data.", e);
            return false;
        }
    }

    private boolean hasTable(Connection connection, String tablename) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet tables = metadata.getTables(null, null, "%", null);
        while (tables.next()) {
            if (!tablename.equals(tables.getString(3))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean rollbackMockData() {
        try (Connection connect = this.getConnection();){
            Liquibase liquibase;
            JdbcConnection databaseConnection = new JdbcConnection(connect);
            ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(((Object)((Object)this)).getClass().getClassLoader());
            if (this.initialChangelog) {
                try (PreparedStatement statement = connect.prepareStatement("delete from user_roles");){
                    statement.executeUpdate();
                }
                statement = connect.prepareStatement("delete from users");
                var6_9 = null;
                try {
                    statement.executeUpdate();
                }
                catch (Throwable throwable2) {
                    var6_9 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement != null) {
                        if (var6_9 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                var6_9.addSuppressed(throwable3);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
                liquibase = new Liquibase("sql/data/db-initial-changelog.xml", (ResourceAccessor)classLoaderResourceAccessor, (DatabaseConnection)databaseConnection);
                liquibase.rollback(3, "");
            } else {
                liquibase = new Liquibase("sql/data/db-changelog.xml", (ResourceAccessor)classLoaderResourceAccessor, (DatabaseConnection)databaseConnection);
                liquibase.rollback(5, "");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logError("Failed to roll back mock data from derby test database.", e);
            return false;
        }
    }

    public String getName() {
        return "Ukelonn Derby test database";
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void forceReleaseLocks() {
        UkelonnLiquibase liquibase = new UkelonnLiquibase();
        try (Connection connect = this.getConnection();){
            liquibase.forceReleaseLocks(connect);
        }
        catch (Exception e) {
            this.logError("Failed to force release Liquibase changelog lock on derby database", e);
        }
    }

    private void logError(String message, Exception exception) {
        if (this.logService != null) {
            this.logService.log(1, message, (Throwable)exception);
        }
    }

    public String sumOverYearQuery() {
        return "select sum(t.transaction_amount), YEAR(t.transaction_time) from transactions t join transaction_types tt on tt.transaction_type_id=t.transaction_type_id join accounts a on a.account_id=t.account_id where tt.transaction_is_work and a.username=? group by YEAR(t.transaction_time) order by YEAR(t.transaction_time)";
    }

    public String sumOverMonthQuery() {
        return "select sum(t.transaction_amount), YEAR(t.transaction_time), MONTH(t.transaction_time) from transactions t join transaction_types tt on tt.transaction_type_id=t.transaction_type_id join accounts a on a.account_id=t.account_id where tt.transaction_is_work and a.username=? group by YEAR(t.transaction_time), MONTH(t.transaction_time) order by YEAR(t.transaction_time), MONTH(t.transaction_time)";
    }
}

