/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.db.liquibase.production;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import no.priv.bang.ukelonn.db.liquibase.UkelonnLiquibase;
import no.priv.bang.ukelonn.db.liquibase.production.UkelonnLiquibaseFactory;
import org.ops4j.pax.jdbc.hook.PreHook;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Component(immediate=true, property={"name=ukelonndb"})
public class ProductionLiquibaseRunner
implements PreHook {
    static final String INITIAL_DATA_DEFAULT_RESOURCE_NAME = "db-changelog/db-changelog.xml";
    private Logger logger;
    private UkelonnLiquibaseFactory ukelonnLiquibaseFactory;
    private String databaselanguage;

    @Reference
    public void setLogService(LogService logService) {
        this.logger = logService.getLogger(this.getClass());
    }

    @Activate
    public void activate(Map<String, Object> config) {
        this.databaselanguage = (String)config.get("databaselanguage");
    }

    public void prepare(DataSource datasource) throws SQLException {
        try {
            UkelonnLiquibase liquibase = this.createUkelonnLiquibase();
            liquibase.createInitialSchema(datasource);
            this.insertInitialDataInDatabase(datasource, liquibase);
            liquibase.updateSchema(datasource);
        }
        catch (Exception e) {
            this.logger.error("Failed to create ukelonn database schema in the PostgreSQL ukelonn database", (Object)e);
        }
    }

    boolean insertInitialDataInDatabase(DataSource datasource, UkelonnLiquibase liquibase) {
        boolean bl;
        block8: {
            Connection connect = datasource.getConnection();
            try {
                liquibase.applyLiquibaseChangelist(connect, this.initialDataResourceName(), this.getClass().getClassLoader());
                bl = true;
                if (connect == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connect != null) {
                        try {
                            connect.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error("Failed to fill ukelonn PostgreSQL database with initial data.", (Object)e);
                    return false;
                }
            }
            connect.close();
        }
        return bl;
    }

    UkelonnLiquibase createUkelonnLiquibase() {
        if (this.ukelonnLiquibaseFactory == null) {
            this.ukelonnLiquibaseFactory = new UkelonnLiquibaseFactory(this){

                @Override
                public UkelonnLiquibase create() {
                    return new UkelonnLiquibase();
                }
            };
        }
        return this.ukelonnLiquibaseFactory.create();
    }

    void setUkelonnLiquibaseFactory(UkelonnLiquibaseFactory ukelonnLiquibaseFactory) {
        this.ukelonnLiquibaseFactory = ukelonnLiquibaseFactory;
    }

    String initialDataResourceName() {
        if (this.databaselanguage == null) {
            return INITIAL_DATA_DEFAULT_RESOURCE_NAME;
        }
        String resourceName = INITIAL_DATA_DEFAULT_RESOURCE_NAME.replace(".xml", "_" + this.databaselanguage + ".xml");
        if (this.getClass().getClassLoader().getResource(resourceName) == null) {
            this.logger.warn(String.format("Failed to find data for %s defaulting to Norwegian", this.databaselanguage));
            return INITIAL_DATA_DEFAULT_RESOURCE_NAME;
        }
        return resourceName;
    }
}

