/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.db.liquibase;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import no.priv.bang.karaf.liquibase.runner.LiquibaseClassPathChangeLogRunner;
import no.priv.bang.ukelonn.UkelonnException;

public class UkelonnLiquibase
extends LiquibaseClassPathChangeLogRunner {
    static final String ERROR_CLOSING_RESOURCE_WHEN_UPDATING_UKELONN_SCHEMA = "Error closing resource when updating ukelonn schema";

    public void createInitialSchema(DataSource datasource) throws LiquibaseException {
        try (Connection connect = datasource.getConnection();){
            this.applyLiquibaseChangelist(connect, "ukelonn-db-changelog/db-changelog-1.0.0.xml");
        }
        catch (LiquibaseException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new UkelonnException("Error closing resource when creating ukelonn initial schema", (Throwable)e1);
        }
    }

    public void updateSchema(DataSource datasource) throws LiquibaseException {
        Connection connect;
        try {
            connect = datasource.getConnection();
            try {
                this.applyLiquibaseChangelist(connect, "ukelonn-db-changelog/db-changelog-1.0.1.xml");
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (LiquibaseException e) {
            throw e;
        }
        catch (SQLException e1) {
            throw new UkelonnException(ERROR_CLOSING_RESOURCE_WHEN_UPDATING_UKELONN_SCHEMA, (Throwable)e1);
        }
        try {
            connect = datasource.getConnection();
            try {
                this.applyLiquibaseChangelist(connect, "ukelonn-db-changelog/db-changelog.xml");
            }
            finally {
                if (connect != null) {
                    connect.close();
                }
            }
        }
        catch (LiquibaseException e) {
            throw e;
        }
        catch (SQLException e1) {
            throw new UkelonnException(ERROR_CLOSING_RESOURCE_WHEN_UPDATING_UKELONN_SCHEMA, (Throwable)e1);
        }
    }

    private void applyLiquibaseChangelist(Connection connect, String liquibaseChangeLogClassPathResource) throws LiquibaseException {
        this.applyLiquibaseChangelist(connect, liquibaseChangeLogClassPathResource, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

