/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.db.postgresql;

import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import no.priv.bang.osgiservice.database.DatabaseServiceBase;
import no.priv.bang.ukelonn.UkelonnDatabase;
import no.priv.bang.ukelonn.db.liquibase.UkelonnLiquibase;
import no.priv.bang.ukelonn.db.postgresql.LiquibaseFactory;
import no.priv.bang.ukelonn.db.postgresql.UkelonnLiquibaseFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.log.LogService;

@Component(service={UkelonnDatabase.class}, immediate=true)
public class PGUkelonnDatabaseProvider
extends DatabaseServiceBase
implements UkelonnDatabase {
    private LogService logService;
    private DataSourceFactory dataSourceFactory;
    private UkelonnLiquibaseFactory ukelonnLiquibaseFactory;
    private LiquibaseFactory liquibaseFactory;
    private DataSource datasource;

    @Reference
    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    @Reference(target="(osgi.jdbc.driver.name=PostgreSQL JDBC Driver)")
    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(Map<String, Object> config) {
        this.createDatasource(config);
        try (Connection connect = this.getConnection();){
            UkelonnLiquibase liquibase = this.createUkelonnLiquibase();
            try {
                liquibase.createInitialSchema(connect);
                this.insertInitialDataInDatabase();
                liquibase.updateSchema(connect);
            }
            finally {
                connect.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            this.logError("Failed to create ukelonn database schema in the PostgreSQL ukelonn database", e);
        }
    }

    void createDatasource(Map<String, Object> config) {
        Properties properties = this.createDatabaseConnectionPropertiesFromOsgiConfig(config);
        try {
            this.datasource = this.dataSourceFactory.createDataSource(properties);
        }
        catch (Exception e) {
            this.logError("PostgreSQL database service failed to create connection to local DB server", e);
        }
    }

    Properties createDatabaseConnectionPropertiesFromOsgiConfig(Map<String, Object> config) {
        String jdbcUrl = (String)config.getOrDefault("ukelonn.db.jdbc.url", "jdbc:postgresql:///ukelonn");
        String jdbcUser = (String)config.get("ukelonn.db.jdbc.user");
        String jdbcPassword = (String)config.get("ukelonn.db.jdbc.password");
        Properties properties = new Properties();
        properties.setProperty("url", jdbcUrl);
        if (jdbcUser != null) {
            properties.setProperty("user", jdbcUser);
        }
        if (jdbcPassword != null) {
            properties.setProperty("password", jdbcPassword);
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean insertInitialDataInDatabase() {
        try (Connection connect = this.getConnection();){
            JdbcConnection databaseConnection = new JdbcConnection(connect);
            ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(((Object)((Object)this)).getClass().getClassLoader());
            Liquibase liquibase = this.createLiquibase("db-changelog/db-changelog.xml", (ResourceAccessor)classLoaderResourceAccessor, (DatabaseConnection)databaseConnection);
            liquibase.update("");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logError("Failed to fill PostgreSQL database with initial data.", e);
            return false;
        }
    }

    public String getName() {
        return "Ukelonn PostgreSQL database";
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void forceReleaseLocks() {
        UkelonnLiquibase liquibase = this.createUkelonnLiquibase();
        try (Connection connect = this.getConnection();){
            liquibase.forceReleaseLocks(connect);
        }
        catch (Exception e) {
            this.logError("Failed to force release Liquibase changelog lock on PostgreSQL database", e);
        }
    }

    UkelonnLiquibase createUkelonnLiquibase() {
        if (this.ukelonnLiquibaseFactory == null) {
            this.ukelonnLiquibaseFactory = new UkelonnLiquibaseFactory(){

                @Override
                public UkelonnLiquibase create() {
                    return new UkelonnLiquibase();
                }
            };
        }
        return this.ukelonnLiquibaseFactory.create();
    }

    void setUkelonnLiquibaseFactory(UkelonnLiquibaseFactory ukelonnLiquibaseFactory) {
        this.ukelonnLiquibaseFactory = ukelonnLiquibaseFactory;
    }

    Liquibase createLiquibase(String changelogfile, ResourceAccessor resourceAccessor, DatabaseConnection databaseConnection) throws LiquibaseException {
        if (this.liquibaseFactory == null) {
            this.liquibaseFactory = new LiquibaseFactory(){

                @Override
                public Liquibase create(String changelogfile, ResourceAccessor resourceAccessor, DatabaseConnection databaseConnection) throws LiquibaseException {
                    return new Liquibase(changelogfile, resourceAccessor, databaseConnection);
                }
            };
        }
        return this.liquibaseFactory.create(changelogfile, resourceAccessor, databaseConnection);
    }

    void setLiquibaseFactory(LiquibaseFactory liquibaseFactory) {
        this.liquibaseFactory = liquibaseFactory;
    }

    private void logError(String message, Exception exception) {
        if (this.logService != null) {
            this.logService.log(1, message, (Throwable)exception);
        }
    }

    public String sumOverYearQuery() {
        return "select sum(t.transaction_amount), extract(year from t.transaction_time) as year from transactions t join transaction_types tt on tt.transaction_type_id=t.transaction_type_id join accounts a on a.account_id=t.account_id where tt.transaction_is_work and a.username=? group by extract(year from t.transaction_time) order by extract(year from t.transaction_time)";
    }

    public String sumOverMonthQuery() {
        return "select sum(t.transaction_amount), extract(year from t.transaction_time) as year, extract(month from t.transaction_time) as month from transactions t join transaction_types tt on tt.transaction_type_id=t.transaction_type_id join accounts a on a.account_id=t.account_id where tt.transaction_is_work and a.username=? group by extract(year from t.transaction_time), extract(month from t.transaction_time) order by extract(year from t.transaction_time), extract(month from t.transaction_time)";
    }
}

