/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.beans;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public record Account(int accountId, String username, String firstName, String lastName, double balance) {
    public String getFullName() {
        if (this.firstName() != null && this.lastName() != null) {
            return this.firstName() + " " + this.lastName();
        }
        if (this.firstName() != null) {
            return this.firstName();
        }
        return this.username();
    }

    public static Builder with() {
        return new Builder();
    }

    public static Builder with(Account account) {
        Builder builder = new Builder();
        builder.accountid = account.accountId;
        builder.username = account.username;
        builder.firstName = account.firstName;
        builder.lastName = account.lastName;
        builder.balance = account.balance;
        return builder;
    }

    public static class Builder {
        private int accountid;
        private String username;
        private String firstName;
        private String lastName;
        private double balance;

        private Builder() {
        }

        public Account build() {
            return new Account(this.accountid, this.username, this.firstName, this.lastName, this.balance);
        }

        public Builder accountid(int accountid) {
            this.accountid = accountid;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder balance(double balance) {
            this.balance = balance;
            return this;
        }
    }
}

