/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.beans;

import java.util.Date;
import java.util.Optional;
import no.priv.bang.ukelonn.beans.Account;

public record PerformedTransaction(Account account, int transactionTypeId, double transactionAmount, Date transactionDate) {
    public static Builder with() {
        return new Builder();
    }

    public static class Builder {
        private Account account;
        private Integer transactionTypeId;
        private Double transactionAmount;
        private Date transactionDate;

        private Builder() {
        }

        public PerformedTransaction build() {
            return new PerformedTransaction(this.account, Optional.ofNullable(this.transactionTypeId).orElse(-1), Optional.ofNullable(this.transactionAmount).orElse(0.0), Optional.ofNullable(this.transactionDate).orElse(new Date()));
        }

        public Builder account(Account account) {
            this.account = account;
            return this;
        }

        public Builder transactionTypeId(Integer transactionTypeId) {
            this.transactionTypeId = transactionTypeId;
            return this;
        }

        public Builder transactionAmount(Double transactionAmount) {
            this.transactionAmount = transactionAmount;
            return this;
        }

        public Builder transactionDate(Date transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }
    }
}

