/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.beans;

import java.util.Date;
import java.util.Optional;
import no.priv.bang.ukelonn.beans.TransactionType;

public record Transaction(int id, TransactionType transactionType, Date transactionTime, double transactionAmount, boolean paidOut) {
    public String getName() {
        return Optional.ofNullable(this.transactionType).map(TransactionType::transactionTypeName).orElse(null);
    }

    public static Builder with(Transaction transaction) {
        Builder builder = new Builder();
        builder.id = transaction.id;
        builder.transactionType = transaction.transactionType;
        builder.transactionTime = transaction.transactionTime;
        builder.transactionAmount = transaction.transactionAmount;
        builder.paidOut = transaction.paidOut;
        return builder;
    }

    public static Builder with() {
        return new Builder();
    }

    public static class Builder {
        private int id = -1;
        private TransactionType transactionType = null;
        private Date transactionTime = null;
        private double transactionAmount = 0.0;
        private boolean paidOut = false;

        private Builder() {
        }

        public Transaction build() {
            return new Transaction(this.id, this.transactionType, this.transactionTime, this.transactionAmount, this.paidOut);
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder transactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public Builder transactionTime(Date transactionTime) {
            this.transactionTime = transactionTime;
            return this;
        }

        public Builder transactionAmount(double transactionAmount) {
            this.transactionAmount = transactionAmount;
            return this;
        }

        public Builder paidOut(boolean paidOut) {
            this.paidOut = paidOut;
            return this;
        }
    }
}

