/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.beans;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public record User(int userId, String username, String email, String firstname, String lastname) {
    public String fullname() {
        return this.firstname() + " " + this.lastname();
    }

    public static Builder with() {
        return new Builder();
    }

    public static Builder with(User user) {
        Builder builder = new Builder();
        builder.userId = user.userId;
        builder.username = user.username;
        builder.email = user.email;
        builder.firstname = user.firstname;
        builder.lastname = user.lastname;
        return builder;
    }

    public static class Builder {
        private int userId = -1;
        private String username = "";
        private String email = "";
        private String firstname = "";
        private String lastname = "";

        private Builder() {
        }

        public User build() {
            return new User(this.userId, this.username, this.email, this.firstname, this.lastname);
        }

        public Builder userId(int userId) {
            this.userId = userId;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder firstname(String firstname) {
            this.firstname = firstname;
            return this;
        }

        public Builder lastname(String lastname) {
            this.lastname = lastname;
            return this;
        }
    }
}

