/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.testutils;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.priv.bang.osgiservice.users.User;
import no.priv.bang.ukelonn.beans.Account;
import no.priv.bang.ukelonn.beans.Transaction;
import no.priv.bang.ukelonn.beans.TransactionType;
import no.priv.bang.ukelonn.beans.UpdatedTransaction;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.SimpleAccountRealm;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.apache.shiro.web.mgt.WebSecurityManager;

public class TestUtils {
    private static no.priv.bang.ukelonn.beans.User jadUser = no.priv.bang.ukelonn.beans.User.with().userId(1).username("jad").email("jane1203@gmail.no").firstname("Jane").lastname("Doe").build();
    private static no.priv.bang.ukelonn.beans.User jodUser = no.priv.bang.ukelonn.beans.User.with().userId(1).username("jod").email("john1203@gmail.no").firstname("John").lastname("Doe").build();
    private static Account jadAccount = Account.with().accountid(1).username("jad").firstName("Jane").lastName("Doe").balance(673.0).build();
    private static Account jodAccount = Account.with().accountid(1).username("jod").firstName("John").lastName("Doe").balance(278.0).build();
    private static TransactionType jobtype1 = TransactionType.with().id(1).transactionTypeName("St\u00f8vsuging").transactionAmount(Double.valueOf(45.0)).transactionIsWork(true).build();
    private static TransactionType jobtype2 = TransactionType.with().id(3).transactionTypeName("T\u00f8mme oppvaskmaskin").transactionAmount(Double.valueOf(35.0)).transactionIsWork(true).build();
    private static TransactionType jobtype3 = TransactionType.with().id(5).transactionTypeName("G\u00e5 med resirk").transactionAmount(Double.valueOf(20.0)).transactionIsWork(true).build();
    private static TransactionType jobtype4 = TransactionType.with().id(6).transactionTypeName("St\u00f8vsuge rommet").transactionAmount(Double.valueOf(15.0)).transactionIsWork(true).build();
    private static List<TransactionType> jobtypes = Arrays.asList(jobtype1, jobtype2, jobtype3, jobtype4);
    private static TransactionType paymenttype1 = TransactionType.with().id(2).transactionTypeName("Inn p\u00e5 konto").transactionIsWagePayment(true).build();
    private static TransactionType paymenttype2 = TransactionType.with().id(4).transactionTypeName("Mobildata").transactionAmount(Double.valueOf(100.0)).transactionIsWagePayment(true).build();
    private static List<TransactionType> paymenttypes = Arrays.asList(paymenttype1, paymenttype2);
    private static Map<Integer, TransactionType> transactionttypes = Collections.unmodifiableMap(Stream.of(jobtypes, paymenttypes).flatMap(Collection::stream).collect(Collectors.toMap(TransactionType::id, t -> t)));
    private static List<Transaction> jadJobs = Arrays.asList(Transaction.with().id(3).transactionType(jobtype1).transactionTime(new Date()).transactionAmount(45.0).paidOut(true).build(), Transaction.with().id(4).transactionType(jobtype2).transactionTime(new Date()).transactionAmount(35.0).paidOut(true).build(), Transaction.with().id(5).transactionType(jobtype1).transactionTime(new Date()).transactionAmount(45.0).build(), Transaction.with().id(6).transactionType(jobtype3).transactionTime(new Date()).transactionAmount(20.0).build(), Transaction.with().id(7).transactionType(jobtype1).transactionTime(new Date()).transactionAmount(45.0).build(), Transaction.with().id(8).transactionType(jobtype4).transactionTime(new Date()).transactionAmount(15.0).build(), Transaction.with().id(9).transactionType(jobtype1).transactionTime(new Date()).transactionAmount(45.0).build(), Transaction.with().id(10).transactionType(jobtype2).transactionTime(new Date()).transactionAmount(35.0).build(), Transaction.with().id(11).transactionType(jobtype3).transactionTime(new Date()).transactionAmount(20.0).build(), Transaction.with().id(12).transactionType(jobtype2).transactionTime(new Date()).transactionAmount(35.0).build());
    private static List<Transaction> jadPayments = Arrays.asList(Transaction.with().id(13).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(210.0).build(), Transaction.with().id(14).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(130.0).build(), Transaction.with().id(15).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(120.0).build(), Transaction.with().id(16).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(270.0).build(), Transaction.with().id(17).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(300.0).build(), Transaction.with().id(18).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(210.0).build(), Transaction.with().id(19).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(180.0).build(), Transaction.with().id(20).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(70.0).build(), Transaction.with().id(21).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(200.0).build(), Transaction.with().id(22).transactionType(paymenttype1).transactionTime(new Date()).transactionAmount(250.0).build());
    private static List<Transaction> jodJobs = Arrays.asList(Transaction.with().id(1).transactionType(jobtype1).transactionTime(new Date()).transactionAmount(45.0).build(), Transaction.with().id(2).transactionType(jobtype2).transactionTime(new Date()).transactionAmount(35.0).build());
    private static WebSecurityManager securitymanager;
    private static SimpleAccountRealm realm;

    public static WebSecurityManager getSecurityManager() {
        if (securitymanager == null) {
            IniWebEnvironment env = new IniWebEnvironment();
            env.setConfigLocations("classpath:test.shiro.ini");
            env.init();
            securitymanager = env.getWebSecurityManager();
            realm = TestUtils.findRealmFromSecurityManager(securitymanager);
        }
        return securitymanager;
    }

    public static SimpleAccount getShiroAccountFromRealm(String username) {
        if (realm == null) {
            TestUtils.getSecurityManager();
        }
        return TestUtils.findUserFromRealm(realm, username);
    }

    private static SimpleAccountRealm findRealmFromSecurityManager(WebSecurityManager securitymanager) {
        RealmSecurityManager realmSecurityManager = (RealmSecurityManager)securitymanager;
        Collection realms = realmSecurityManager.getRealms();
        return (SimpleAccountRealm)realms.iterator().next();
    }

    private static SimpleAccount findUserFromRealm(SimpleAccountRealm realm, String username) {
        try {
            Method getUserMethod = SimpleAccountRealm.class.getDeclaredMethod("getUser", String.class);
            getUserMethod.setAccessible(true);
            return (SimpleAccount)getUserMethod.invoke((Object)realm, username);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getResourceAsFile(String resource) throws URISyntaxException {
        return Paths.get(TestUtils.class.getResource(resource).toURI()).toFile();
    }

    private static no.priv.bang.ukelonn.beans.User copyUser(no.priv.bang.ukelonn.beans.User user) {
        return no.priv.bang.ukelonn.beans.User.with((no.priv.bang.ukelonn.beans.User)user).build();
    }

    private static User copyUserForUserManagement(no.priv.bang.ukelonn.beans.User user) {
        return User.with().userid(user.userId()).username(user.username()).email(user.email()).firstname(user.firstname()).lastname(user.firstname()).build();
    }

    public static TransactionType copyTransactionType(TransactionType transactiontype) {
        return TransactionType.with((TransactionType)transactiontype).build();
    }

    public static List<TransactionType> copyTransactiontypes(List<TransactionType> transactiontypes) {
        return transactiontypes.stream().map(transactiontype -> TestUtils.copyTransactionType(transactiontype)).toList();
    }

    public static Transaction convertUpdatedTransaction(UpdatedTransaction transaction) {
        return Transaction.with().id(transaction.id()).transactionType(transactionttypes.get(transaction.transactionTypeId())).transactionTime(transaction.transactionTime()).transactionAmount(transaction.transactionAmount()).build();
    }

    public static Transaction copyTransaction(Transaction transaction) {
        return Transaction.with((Transaction)transaction).build();
    }

    public static List<Transaction> copyTransactions(List<Transaction> transactions) {
        return transactions.stream().map(transaction -> TestUtils.copyTransaction(transaction)).toList();
    }

    public static List<TransactionType> getJobtypes() {
        return TestUtils.copyTransactiontypes(jobtypes);
    }

    public static List<TransactionType> getPaymenttypes() {
        return TestUtils.copyTransactiontypes(paymenttypes);
    }

    public static List<no.priv.bang.ukelonn.beans.User> getUsers() {
        return Arrays.asList(TestUtils.copyUser(jadUser), TestUtils.copyUser(jodUser));
    }

    public static List<User> getUsersForUserManagement() {
        return Arrays.asList(TestUtils.copyUserForUserManagement(jadUser), TestUtils.copyUserForUserManagement(jodUser));
    }

    public static Account getJadAccount() {
        return Account.with((Account)jadAccount).build();
    }

    public static Account getJodAccount() {
        return Account.with((Account)jodAccount).build();
    }

    public static List<Transaction> getJadJobs() {
        return TestUtils.copyTransactions(jadJobs);
    }

    public static List<Transaction> getJadPayments() {
        return TestUtils.copyTransactions(jadPayments);
    }

    public static List<Transaction> getJodJobs() {
        return TestUtils.copyTransactions(jodJobs);
    }

    public static List<Transaction> getFirstJodJob() {
        return jodJobs.stream().limit(1L).toList();
    }

    public static List<Account> getDummyAccounts() {
        return Arrays.asList(TestUtils.getJadAccount(), TestUtils.getJodAccount());
    }
}

