/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.api.resources;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import no.priv.bang.ukelonn.UkelonnService;
import no.priv.bang.ukelonn.beans.AccountWithJobIds;
import no.priv.bang.ukelonn.beans.Transaction;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="/admin/jobs")
@Produces(value={"application/json"})
@RequiresUser
@RequiresRoles(value={"ukelonnadmin"})
public class AdminJobs {
    @Inject
    UkelonnService ukelonn;
    Logger logger;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(this.getClass());
    }

    @Path(value="delete")
    @POST
    @Consumes(value={"application/json"})
    public List<Transaction> delete(AccountWithJobIds accountWithJobIds) {
        try {
            return this.ukelonn.deleteJobsFromAccount(accountWithJobIds.account().accountId(), accountWithJobIds.jobIds());
        }
        catch (Exception e) {
            String message = "REST endpoint /ukelonn/admin/jobs/delete failed with exception";
            this.logger.error(message, (Object)e);
            throw new InternalServerErrorException(String.format("%s, see log for details", message));
        }
    }
}

