/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.api.resources;

import java.util.Arrays;
import java.util.Base64;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import no.priv.bang.ukelonn.api.beans.LoginCredentials;
import no.priv.bang.ukelonn.api.beans.LoginResult;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="/login")
@Produces(value={"application/json"})
public class Login {
    Logger logger;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(this.getClass());
    }

    @GET
    public LoginResult loginStatus() {
        Subject subject = SecurityUtils.getSubject();
        return this.createLoginResultFromSubject(subject);
    }

    @POST
    @Consumes(value={"application/json"})
    public LoginResult doLogin(LoginCredentials credentials) {
        Subject subject = SecurityUtils.getSubject();
        String decodedPassword = new String(Base64.getDecoder().decode(credentials.password()));
        UsernamePasswordToken token = new UsernamePasswordToken(credentials.username(), decodedPassword, true);
        try {
            subject.login((AuthenticationToken)token);
            LoginResult loginResult = this.createLoginResultFromSubject(subject);
            return loginResult;
        }
        catch (UnknownAccountException e) {
            this.logger.warn("Login error: unknown account", (Object)e);
            LoginResult loginResult = LoginResult.with().errorMessage("Unknown account").build();
            return loginResult;
        }
        catch (IncorrectCredentialsException e) {
            this.logger.warn("Login error: wrong password", (Object)e);
            LoginResult loginResult = LoginResult.with().errorMessage("Wrong password").build();
            return loginResult;
        }
        catch (ExcessiveAttemptsException e) {
            this.logger.warn("Login error: Failed login attempts limit reached, account locked", (Object)e);
            LoginResult loginResult = LoginResult.with().errorMessage("Login error: Failed login attempts limit reached. Account will be locked. Please contact system administrator").build();
            return loginResult;
        }
        catch (LockedAccountException e) {
            this.logger.warn("Login error: locked account", (Object)e);
            LoginResult loginResult = LoginResult.with().errorMessage("Locked account").build();
            return loginResult;
        }
        catch (AuthenticationException e) {
            this.logger.warn("Login error: general authentication error", (Object)e);
            LoginResult loginResult = LoginResult.with().errorMessage("Unknown error").build();
            return loginResult;
        }
        catch (Exception e) {
            this.logger.error("Login error: internal server error", (Object)e);
            throw new InternalServerErrorException();
        }
        finally {
            token.clear();
        }
    }

    private LoginResult createLoginResultFromSubject(Subject subject) {
        if (subject.isAuthenticated()) {
            String[] roles = new String[]{"user"};
            if (subject.hasRole("ukelonnadmin")) {
                roles = new String[]{"ukelonnadmin"};
            }
            String username = (String)subject.getPrincipal();
            return LoginResult.with().username(username).roles(Arrays.asList(roles)).build();
        }
        return LoginResult.with().build();
    }
}

