/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.api.resources;

import java.util.Optional;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import no.priv.bang.ukelonn.api.resources.ErrorMessage;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

public class ResourceBase {
    protected boolean isCurrentUserOrAdmin(String username, LogService logservice) {
        Logger logger = logservice.getLogger(this.getClass());
        try {
            Optional<Subject> subject = Optional.ofNullable(SecurityUtils.getSubject());
            Boolean isCurrentUser = subject.map(s -> (String)s.getPrincipal()).map(principal -> principal.equals(username)).orElse(false);
            return subject.map(s -> s.hasRole("ukelonnadmin") || isCurrentUser != false).orElse(false);
        }
        catch (Exception e) {
            String message = "Failure retrieving Shiro subject";
            logger.error(message, (Object)e);
            throw new InternalServerErrorException(message);
        }
    }

    protected Response response(int status, String message) {
        return Response.status((int)status).entity((Object)new ErrorMessage(status, message)).type("application/json").build();
    }
}

