/*
 * Copyright 2018-2024 Steinar Bang
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations
 * under the License.
 */
package no.priv.bang.ukelonn.api.resources;

import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.osgi.service.log.LogService;

import no.priv.bang.ukelonn.api.beans.LoginResult;

@Path("/logout")
@Produces(MediaType.APPLICATION_JSON)
@RequiresUser
public class Logout {

    @Inject
    LogService logservice;

    @POST
    public LoginResult doLogout() {
        var subject = SecurityUtils.getSubject();

        subject.logout();
        return LoginResult.with().build();
    }

}
