/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.api.resources;

import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import no.priv.bang.ukelonn.UkelonnException;
import no.priv.bang.ukelonn.UkelonnService;
import no.priv.bang.ukelonn.api.resources.ResourceBase;
import no.priv.bang.ukelonn.beans.Account;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="/account")
@Produces(value={"application/json"})
@RequiresUser
public class AccountResource
extends ResourceBase {
    static final String USERNAME_MISSING_ERROR = "REST endpoint /ukelonn/api/account requires a username argument, and the request was missing a username argument";
    private LogService logservice;
    Logger logger;
    @Inject
    UkelonnService ukelonn;

    @Inject
    void setLogservice(LogService logservice) {
        this.logservice = logservice;
        this.logger = logservice.getLogger(this.getClass());
    }

    @GET
    @Path(value="{username}")
    public Account getAccount(@PathParam(value="username") String username) {
        if (username == null) {
            this.logger.warn(USERNAME_MISSING_ERROR);
            throw new BadRequestException(USERNAME_MISSING_ERROR);
        }
        if (!this.isCurrentUserOrAdmin(username, this.logservice)) {
            this.logger.warn(String.format("REST endpoint /ukelonn/api/account logged in user not allowed to fetch account for username %s", username));
            throw new ForbiddenException();
        }
        try {
            return this.ukelonn.getAccount(username);
        }
        catch (UkelonnException e) {
            this.logger.error(String.format("Internal Server Error in REST endpoint /ukelonn/api/account: %s", e.getMessage()), (Object)e);
            throw new InternalServerErrorException("Failed to get account from database. See log for details.");
        }
    }
}

