/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.api.resources;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import no.priv.bang.ukelonn.UkelonnException;
import no.priv.bang.ukelonn.UkelonnService;
import no.priv.bang.ukelonn.beans.TransactionType;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="/admin/paymenttype")
@Produces(value={"application/json"})
@RequiresUser
@RequiresRoles(value={"ukelonnadmin"})
public class AdminPaymenttype {
    @Inject
    UkelonnService ukelonn;
    Logger logger;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(this.getClass());
    }

    @Path(value="modify")
    @POST
    @Consumes(value={"application/json"})
    public List<TransactionType> modify(TransactionType paymenttype) {
        try {
            return this.ukelonn.modifyPaymenttype(paymenttype);
        }
        catch (UkelonnException e) {
            this.logger.error(String.format("REST endpoint /api/paymenttype/modify failed to modify payment type %d in the database", paymenttype.id()), (Object)e);
            throw new InternalServerErrorException("See log for the cause of the problem");
        }
    }

    @Path(value="create")
    @POST
    @Consumes(value={"application/json"})
    public List<TransactionType> create(TransactionType paymenttype) {
        try {
            return this.ukelonn.createPaymenttype(paymenttype);
        }
        catch (UkelonnException e) {
            this.logger.error(String.format("REST endpoint /api/jobtype/modify failed to create payment type \"%s\" in the database", paymenttype.transactionTypeName()), (Object)e);
            throw new InternalServerErrorException("See log for the cause of the problem");
        }
    }
}

