/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.api.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import no.priv.bang.authservice.definitions.AuthserviceException;
import no.priv.bang.authservice.definitions.AuthservicePasswordEmptyException;
import no.priv.bang.authservice.definitions.AuthservicePasswordsNotIdenticalException;
import no.priv.bang.osgiservice.users.Role;
import no.priv.bang.osgiservice.users.User;
import no.priv.bang.osgiservice.users.UserAndPasswords;
import no.priv.bang.osgiservice.users.UserManagementService;
import no.priv.bang.osgiservice.users.UserRoles;
import no.priv.bang.ukelonn.UkelonnException;
import no.priv.bang.ukelonn.UkelonnService;
import no.priv.bang.ukelonn.api.beans.AdminStatus;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="/admin/user")
@Produces(value={"application/json"})
@RequiresUser
@RequiresRoles(value={"ukelonnadmin"})
public class AdminUserResource {
    @Inject
    UserManagementService useradmin;
    @Inject
    UkelonnService ukelonn;
    Logger logger;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(this.getClass());
    }

    @Path(value="modify")
    @POST
    @Consumes(value={"application/json"})
    public List<User> modify(User user) {
        try {
            return this.useradmin.modifyUser(user);
        }
        catch (AuthserviceException e) {
            this.logger.error(String.format("REST endpoint /ukelonn/api/admin/user/modify failed to modify user %d", user.userid()));
            throw new InternalServerErrorException("See log for details");
        }
    }

    @Path(value="create")
    @POST
    @Consumes(value={"application/json"})
    public List<User> create(UserAndPasswords passwords) {
        try {
            List users = this.useradmin.addUser(passwords);
            String username = passwords.user().username();
            Optional<User> createdUser = users.stream().filter(u -> username.equals(u.username())).findFirst();
            if (!createdUser.isPresent()) {
                throw new UkelonnException(String.format("Found no user matching %s in the users table", username));
            }
            no.priv.bang.ukelonn.beans.User user = no.priv.bang.ukelonn.beans.User.with().userId(createdUser.get().userid()).username(username).email(createdUser.get().email()).firstname(createdUser.get().firstname()).lastname(createdUser.get().lastname()).build();
            this.ukelonn.addAccount(user);
            return users;
        }
        catch (AuthserviceException e) {
            this.logger.error("REST endpoint /ukelonn/api/admin/user/create got error from the database", (Object)e);
            throw new InternalServerErrorException("See log for error cause");
        }
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/json"})
    public List<User> password(UserAndPasswords passwords) {
        try {
            return this.useradmin.updatePassword(passwords);
        }
        catch (AuthservicePasswordEmptyException e) {
            this.logger.warn("REST endpoint /ukelonn/api/admin/user/password received empty password");
            throw new BadRequestException(e.getMessage());
        }
        catch (AuthservicePasswordsNotIdenticalException e) {
            this.logger.warn("REST endpoint /ukelonn/api/admin/user/password received passwords that weren't identical");
            throw new BadRequestException(e.getMessage());
        }
        catch (AuthserviceException e) {
            this.logger.error(String.format("REST endpoint /ukelonn/api/admin/user/password got bad request: %s", e.getMessage()));
            throw new InternalServerErrorException("See log for error details");
        }
    }

    @Path(value="adminstatus")
    @POST
    @Consumes(value={"application/json"})
    public AdminStatus adminStatus(User user) {
        boolean administrator = this.userIsAdministrator(user);
        return AdminStatus.with().user(user).administrator(administrator).build();
    }

    @Path(value="changeadminstatus")
    @POST
    @Consumes(value={"application/json"})
    public AdminStatus changeAdminStatus(AdminStatus status) {
        if (status.administrator() != this.userIsAdministrator(status.user())) {
            Optional<Role> ukelonnadmin = this.useradmin.getRoles().stream().filter(r -> "ukelonnadmin".equals(r.rolename())).findFirst();
            if (!ukelonnadmin.isPresent()) {
                return AdminStatus.with().user(status.user()).administrator(false).build();
            }
            if (status.administrator()) {
                this.useradmin.addUserRoles(UserRoles.with().user(status.user()).roles(Arrays.asList(ukelonnadmin.get())).build());
            } else {
                this.useradmin.removeUserRoles(UserRoles.with().user(status.user()).roles(Arrays.asList(ukelonnadmin.get())).build());
            }
        }
        return AdminStatus.with().user(status.user()).administrator(this.userIsAdministrator(status.user())).build();
    }

    boolean userIsAdministrator(User user) {
        return this.useradmin.getRolesForUser(user.username()).stream().anyMatch(r -> "ukelonnadmin".equals(r.rolename()));
    }
}

