/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.api.resources;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import no.priv.bang.ukelonn.UkelonnException;
import no.priv.bang.ukelonn.UkelonnService;
import no.priv.bang.ukelonn.api.resources.ResourceBase;
import no.priv.bang.ukelonn.beans.Account;
import no.priv.bang.ukelonn.beans.PerformedTransaction;
import no.priv.bang.ukelonn.beans.Transaction;
import no.priv.bang.ukelonn.beans.UpdatedTransaction;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="/job")
@Produces(value={"application/json"})
@RequiresUser
public class JobResource
extends ResourceBase {
    private LogService logservice;
    Logger logger;
    @Inject
    UkelonnService ukelonn;

    @Inject
    void setLogservice(LogService logservice) {
        this.logservice = logservice;
        this.logger = logservice.getLogger(this.getClass());
    }

    @Path(value="/register")
    @POST
    @Consumes(value={"application/json"})
    public Account doRegisterJob(PerformedTransaction performedJob) {
        String username = performedJob.account().username();
        if (!this.isCurrentUserOrAdmin(username, this.logservice)) {
            this.logger.warn(String.format("REST Endpoint /ukelonn/api/account logged in user not allowed to fetch account for username %s", username));
            throw new ForbiddenException();
        }
        return this.ukelonn.registerPerformedJob(performedJob);
    }

    @Path(value="/update")
    @POST
    @Consumes(value={"application/json"})
    public List<Transaction> doUpdateJob(UpdatedTransaction editedJob) {
        try {
            return this.ukelonn.updateJob(editedJob);
        }
        catch (UkelonnException e) {
            this.logger.error("REST endpoint /api/job/update failed", (Object)e);
            throw new InternalServerErrorException("See log for details");
        }
    }
}

