/*
 * Decompiled with CFR 0.152.
 */
package no.priv.bang.ukelonn.api.resources;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import no.priv.bang.ukelonn.UkelonnService;
import no.priv.bang.ukelonn.api.resources.ResourceBase;
import no.priv.bang.ukelonn.beans.LocaleBean;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

@Path(value="")
public class LocalizationResource
extends ResourceBase {
    @Inject
    UkelonnService ukelonn;
    Logger logger;

    @Inject
    void setLogservice(LogService logservice) {
        this.logger = logservice.getLogger(this.getClass());
    }

    @GET
    @Path(value="defaultlocale")
    @Produces(value={"application/json"})
    public Locale defaultLocale() {
        return this.ukelonn.defaultLocale();
    }

    @GET
    @Path(value="availablelocales")
    @Produces(value={"application/json"})
    public List<LocaleBean> availableLocales() {
        return this.ukelonn.availableLocales();
    }

    @GET
    @Path(value="displaytexts")
    @Produces(value={"application/json"})
    public Response displayTexts(@QueryParam(value="locale") String locale) {
        try {
            return Response.ok((Object)this.ukelonn.displayTexts(Locale.forLanguageTag(locale.replace('_', '-')))).build();
        }
        catch (MissingResourceException e) {
            String message = String.format("Unknown locale '%s' used when fetching GUI texts", locale);
            this.logger.error(message);
            return this.response(500, message);
        }
    }
}

